package com.yidianling.im.session.viewholder;

import androidx.appcompat.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydlcommon.utils.AnimUtils;
import com.yidianling.im.R;
import com.yidianling.im.bean.DoctorAssistantRespDtoBean;
import com.yidianling.im.helper.IMChatUtil;
import com.yidianling.im.http.ImRetrofitApi;
import com.yidianling.im.session.extension.CustomRecommendExpertListMsg;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.yidianling.uikit.custom.http.response.RecommendExpertBean;
import com.ydl.ydlcommon.view.CircleImageView;

import java.util.ArrayList;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

/**
 * @author xj
 * @描述: 推荐专家列表消息holder
 * @Copyright Copyright (c) 2019
 * @Company 壹点灵
 * @date 2019/6/27
 */
public class MsgViewHolderRecommendExpertList extends MsgViewHolderBase {

    private ArrayList<RecommendExpertBean> list = null;
    private LinearLayout recommendLlScroll;
    private TextView tv_outline_left;
    private TextView tv_outline_right;
    private LinearLayout ll_recommend_expert;
    private HorizontalScrollView recommend_ll_scroll_view;
    private TextView recommend_ll_scroll_view_top_text;

    public MsgViewHolderRecommendExpertList(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    @Override
    protected int getContentResId() {
        return R.layout.im_ui_message_custom_recommand_expert_list;
    }

    @Override
    protected void inflateContentView() {
        recommend_ll_scroll_view = view.findViewById(R.id.recommend_ll_scroll_view);
        ll_recommend_expert = view.findViewById(R.id.ll_recommend_expert);
        recommend_ll_scroll_view_top_text = view.findViewById(R.id.recommend_ll_scroll_view_top_text);
        recommendLlScroll = view.findViewById(R.id.recommend_ll_scroll);
        tv_outline_left = view.findViewById(R.id.tv_outline_left);
        tv_outline_right = view.findViewById(R.id.tv_outline_right);
    }

    @Override
    protected void bindContentView() {
        MsgAttachment attachment = message.getAttachment();
        if (attachment instanceof CustomRecommendExpertListMsg) {
            if (((CustomRecommendExpertListMsg) attachment).getMessageType() == 1) {
                tv_outline_left.setVisibility(View.VISIBLE);
                tv_outline_left.setText("当前咨询师离线");
                tv_outline_right.setVisibility(View.VISIBLE);
                tv_outline_right.setText("提醒他上线");
                tv_outline_right.setOnClickListener(v -> {
                            String toUid = ActionHandlerStorage.getL(message.getSessionId()).getInfo().toUid;
                            ImRetrofitApi.Companion.getImJavaApi().getChatUid(toUid)
                                    .subscribeOn(Schedulers.io())
                                    .observeOn(AndroidSchedulers.mainThread())
                                    .subscribe(resp -> {

                                        DoctorAssistantRespDtoBean bean = resp.data;
                                        //如果两个uid相等，则该专家未绑定助理，直接推送上线提醒消息；如果两个uid不相等，则进入销售代运营服务（与助理私聊）
                                        if (String.valueOf(bean.chatUid).equals(toUid)) {
                                            ActionHandlerStorage.getL(message.getSessionId()).judgeSendRemindMsg(message.getSessionId());
                                        } else {
                                            IMChatUtil.INSTANCE.startChat((AppCompatActivity) context,toUid,0);
                                        }

                                    });
                        }
                );
            } else if (((CustomRecommendExpertListMsg) attachment).getMessageType() == 2) {
                tv_outline_left.setVisibility(View.VISIBLE);
                tv_outline_left.setText("当前咨询师忙碌，可能无法及时回复");
            }

            //是否展示推荐专家列表
            if ((((CustomRecommendExpertListMsg) attachment).getShowExpertList())) {
                list = new ArrayList();
                list = ((CustomRecommendExpertListMsg) attachment).getList();

                if (null != list && list.size() > 0 && recommendLlScroll.getChildCount() == 0) {
                    for (int i = 0; i < list.size(); i++) {
                        RecommendExpertBean bean = list.get(i);
                        View view = View.inflate(context, R.layout.im_ui_message_custom_recommand_expert_list_item, null);
                        CircleImageView headImg = view.findViewById(R.id.recommmend_expert_head);
                        if (!TextUtils.isEmpty(bean.getHead())) {
                            GlideApp.with(context).load(bean.getHead()).into(headImg);
                        }
                        //专家姓名
                        ((TextView) view.findViewById(R.id.recommmend_expert_name)).setText(bean.getName());
                        //专家级别
                        ((TextView) view.findViewById(R.id.recommmend_expert_grade)).setText(bean.getTags());
                        //专家帮助人数
                        ((TextView) view.findViewById(R.id.recommend_expert_help_number)).setText(bean.getHelpCount() + "人");
                        //专家服务时长
                        ((TextView) view.findViewById(R.id.recommend_expert_hour_number)).setText(Math.ceil(bean.getHelpLong() / 60) + "小时");//向上取整
                        //专家好评率
                        ((TextView) view.findViewById(R.id.recommend_expert_good_number)).setText((int) (bean.getFeedbackRate() * 20) + "%"); //取整,以5为满分

                        //设置tag标签
                        if (!TextUtils.isEmpty(bean.getTag1())) {
                            LinearLayout recommmendExpertTagsLl = view.findViewById(R.id.recommmend_expert_tags_ll);
                            String[] tagList = bean.getTag1().split("\\|");
                            for (int j = 0; j < tagList.length && j < 3; j++) {
                                View tagView = View.inflate(context, R.layout.im_ui_message_custom_recommand_expert_list_item_tag, null);
                                ((TextView) tagView.findViewById(R.id.recommand_expert_list_item_tag_tv)).setText(tagList[j]);
                                recommmendExpertTagsLl.addView(tagView);
                            }
                        }

                        recommendLlScroll.addView(view);

                        view.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                ActionHandlerStorage.getL(message.getSessionId()).toExpertHome(String.valueOf(bean.getDoctorId()), bean.getName(), bean.getDoctorSearchShare().getCover());
                            }
                        });
                    }
                }else {
                    recommend_ll_scroll_view.setVisibility(View.GONE);
                    recommend_ll_scroll_view_top_text.setVisibility(View.GONE);
                }
            }else {
                recommend_ll_scroll_view.setVisibility(View.GONE);
                recommend_ll_scroll_view_top_text.setVisibility(View.GONE);
            }
        }
        hideHead();
        hideItemBg();
        AnimUtils.Companion.slideToUp(ll_recommend_expert);
    }

    @Override
    protected void onItemClick() {
    }
}
