package com.yidianling.im.ui.page.fragment

import android.content.Context
import androidx.recyclerview.widget.LinearLayoutManager
import android.view.View
import com.jcodecraeer.xrecyclerview.XRecyclerView
import com.ydl.ydlcommon.base.BaseFragment
import com.ydl.ydlcommon.data.http.RxUtils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.im.R
import com.yidianling.im.event.MessageListRefreshEvent
import com.yidianling.im.http.ImHttpImpl
import com.yidianling.im.router.ImIn
import com.yidianling.im.ui.page.fragment.adapter.NoticeAdapter
import com.yidianling.im.ui.page.fragment.bean.NoticeItemBean
import com.yidianling.im.ui.page.widget.ChatUnusualView
import com.yidianling.im.ui.param.NoticeParam
import de.greenrobot.event.EventBus
import kotlinx.android.synthetic.main.im_notice_fragment.*

/**
 * 通知列表页面
 * Created by xj on 2019/10/11.
 */
class NoticeFragment : BaseFragment(), XRecyclerView.LoadingListener {

    private lateinit var  mContext: Context
    private var noticeAdapter: NoticeAdapter? = null
    private var noticeList: ArrayList<NoticeItemBean> = ArrayList()

    override fun layoutResId(): Int {
        return R.layout.im_notice_fragment
    }

    override fun initDataAndEvent() {
        mContext = requireContext()
        initListData()
    }

    private fun initListData() {
        noticeAdapter = NoticeAdapter(mContext, noticeList)
        notice_recyclerview.layoutManager =
            LinearLayoutManager(context)
        notice_recyclerview.adapter = noticeAdapter
        notice_recyclerview.setLoadingListener(this)
    }

    override fun onLoadMore() {
        notice_recyclerview.setNoMore(true)
    }

    override fun onRefresh() {
        EventBus.getDefault().post(MessageListRefreshEvent(2))
        getNoticeMessageData()
    }

    /**
     * 获取通知消息
     */
    fun getNoticeMessageData() {
        if (ImIn.getUserInfo()?.uid != "0") {
            var  dis = ImHttpImpl.getInstance().getNoticeMessage(NoticeParam("${ImIn.getUserInfo()?.uid}"))
                    .compose(RxUtils.applySchedulers(this))
                    .compose(RxUtils.resultJavaData())
                    .subscribe({ it ->
                        noticeList.clear()
                        // content为空的不展示
                        noticeList.addAll(it.filter { it.content != "" })
                        noticeAdapter?.notifyDataSetChanged()
                        resetPageShow()
                        notice_recyclerview.refreshComplete()
                    }, { t ->
                        ToastUtil.toastShort("您的网络出现了问题")
                        notice_recyclerview.refreshComplete()
                    })
        }
    }

    override fun onResume() {
        super.onResume()
        resetPageShow()
    }

    fun nextUnReadItem() {

    }

    override fun setUserVisibleHint(isVisibleToUser: Boolean) {
        super.setUserVisibleHint(isVisibleToUser)
        if (isVisibleToUser && getIsViewCreated()) {
            // 每次展示的时候都需要处理页面展示逻辑
            resetPageShow()
        }
    }

    fun clearData() {
        noticeList.clear()
        noticeAdapter?.notifyDataSetChanged()
        resetPageShow()
    }

    /**
     * 页面展示状态逻辑
     */
    private fun resetPageShow() {
        if (ImIn.isLogin()) {
            //登录状态
            if (noticeList.size != 0) {
                //数据不为空
                notice_recyclerview.visibility = View.VISIBLE
                ll_notice_unusual_view.visibility = View.GONE
            }else {
                notice_recyclerview.visibility = View.GONE
                ll_notice_unusual_view.visibility = View.VISIBLE
                ll_notice_unusual_view.setUnusualType(ChatUnusualView.TYPE_NOTIFICATION_NO_DATA)
            }
        }else {
            //未登录
            notice_recyclerview.visibility = View.GONE
            ll_notice_unusual_view.visibility = View.VISIBLE
            ll_notice_unusual_view.setUnusualType(ChatUnusualView.TYPE_UNLOGIN)
            ll_notice_unusual_view.setListener(object : ChatUnusualView.ChatUnusualListener {
                override fun onButtonClick() {
                    ImIn.loginByOneKeyLogin(mContext,true)
                }
            })
        }
    }

    override fun initDataAndEventLazy() {
    }
}