package com.yidianling.im.ui.page.fragment.view

import android.content.Context
import android.text.Html
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.netease.nimlib.sdk.NIMClient
import com.netease.nimlib.sdk.team.TeamService
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.im.R
import com.yidianling.im.preference.ImTempData
import com.yidianling.im.ui.page.fragment.bean.ChatItemBean
import kotlinx.android.synthetic.main.im_chat_item_view.view.*

/**
 * 互动列表普通itemView
 */
class ChatItemView(mContext: Context) : LinearLayout(mContext) {

    init {
        val params = LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.WRAP_CONTENT
        )
        layoutParams = params
        View.inflate(mContext, R.layout.im_chat_item_view, this)
    }

    fun initData(bean: ChatItemBean?) {
        bean?.let {
            GlideApp.with(context)
                .load(bean.head)
                .circleCrop()
                .into(chat_message_img)
            chat_message_name.text = bean.toName
            if (bean.doctorTitle != "") {
                chat_message_tab.visibility = View.VISIBLE
                chat_message_tab.text = bean.doctorTitle
            } else {
                chat_message_tab.visibility = View.GONE
            }

            // 咨询优先显示 再倾诉
            when {
                bean.orderStatus == 1 -> {
                    chat_message_sub_desc.visibility = View.VISIBLE
                    chat_message_sub_desc.text = "咨询服务中"
                }
                bean.listenOrderStatus == 1 -> {
                    chat_message_sub_desc.visibility = View.VISIBLE
                    chat_message_sub_desc.text = "倾诉服务中"
                }
                bean.orderCount != 0 -> {
                    chat_message_sub_desc.visibility = View.VISIBLE
                    chat_message_sub_desc.text = "已咨询${bean.orderCount}次"
                }
                bean.listenOrderCount != 0 -> {
                    chat_message_sub_desc.visibility = View.VISIBLE
                    chat_message_sub_desc.text = "已倾诉${bean.listenOrderCount}次"
                }
                else -> chat_message_sub_desc.visibility = View.GONE
            }

            chat_message_time.text = bean.timeStr
            if (ImTempData.getInstance().getTempMsg(bean.toUid.toString()) != null && ImTempData.getInstance().getTempMsg(
                    bean.toUid.toString()
                ) != ""
            ) run {
                //if草稿箱有消息则显示
                val th =
                    "<font color='#EA0000' charset='utf-8'>[草稿]</font> " + ImTempData.getInstance().getTempMsg(
                        bean.toUid.toString()
                    )
                chat_message_content.setText(Html.fromHtml(th))
            }else if (!bean.noReadAtContent.isNullOrEmpty()){
                    var th = "<font color='#FF7766' charset='utf-8'>[有人@我]</font> " + bean.content;
                    chat_message_content.setText(Html.fromHtml(th));
            }else {
                chat_message_content.text = bean.content
            }



            if (bean.is_top == 1) {
                chat_global_ll.setBackgroundResource(R.drawable.im_chat_is_top_bg)
            } else {
                chat_global_ll.setBackgroundResource(0)
            }
            //如果是群聊 根据免打扰状态判断逻辑
            if (bean.chat_type==2){
                val notifyType = NIMClient.getService(TeamService::class.java)
                    .queryTeamBlock(bean.toUid.toString()).messageNotifyType.value // 群消息提醒
                if (notifyType==0){
                    //有消息提醒
                    not_disturb.visibility=View.GONE
                    if (bean.unReadNum > 99) {
                        chat_message_unread_num.visibility = View.VISIBLE
                        chat_message_unread_num.text = "99+"
                    } else if (bean.unReadNum > 0) {
                        chat_message_unread_num.visibility = View.VISIBLE
                        chat_message_unread_num.text = "${bean.unReadNum}"
                    } else {
                        chat_message_unread_num.visibility = View.GONE
                    }
                }else{
                    val layoutParams: ViewGroup.LayoutParams = chat_message_unread_num.getLayoutParams()
                    layoutParams.height = 36
                    layoutParams.width = 36
                    chat_message_unread_num.setLayoutParams(layoutParams)
                    not_disturb.visibility=View.VISIBLE
                    if (bean.unReadNum > 0){
                        chat_message_unread_num.visibility=View.VISIBLE
                        chat_message_unread_num.text=""
                    }else{
                        chat_message_unread_num.visibility = View.GONE
                    }
                }
            }else{
                if (bean.unReadNum > 99) {
                    chat_message_unread_num.visibility = View.VISIBLE
                    chat_message_unread_num.text = "99+"
                } else if (bean.unReadNum > 0) {
                    chat_message_unread_num.visibility = View.VISIBLE
                    chat_message_unread_num.text = "${bean.unReadNum}"
                } else {
                    chat_message_unread_num.visibility = View.GONE
                }
                not_disturb.visibility=View.GONE
            }

        }
    }

}