package com.yidianling.uikit.business.ait.selector.adapter;

import androidx.recyclerview.widget.RecyclerView;

import com.yidianling.im.R;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemQuickAdapter;
import com.yidianling.nimbase.common.ui.recyclerview.holder.BaseViewHolder;
import com.yidianling.uikit.business.ait.selector.holder.SimpleLabelViewHolder;
import com.yidianling.uikit.business.ait.selector.holder.TeamMemberViewHolder;
import com.yidianling.uikit.business.ait.selector.model.AitContactItem;
import com.yidianling.uikit.business.ait.selector.model.ItemType;

import java.util.List;

/**
 * Created by hzchenkang on 2017/6/21.
 */

public class AitContactAdapter extends BaseMultiItemQuickAdapter<AitContactItem, BaseViewHolder> {

    public AitContactAdapter(RecyclerView recyclerView, List<AitContactItem> data) {
        super(recyclerView, data);
        addItemType(ItemType.SIMPLE_LABEL, R.layout.im_nim_ait_contact_label_item, SimpleLabelViewHolder.class);
        addItemType(ItemType.TEAM_MEMBER, R.layout.im_nim_ait_contact_team_member_item, TeamMemberViewHolder.class);
    }

    @Override
    protected int getViewType(AitContactItem item) {
        return item.getViewType();
    }

    @Override
    protected String getItemKey(AitContactItem item) {
        return "" + item.getViewType() + item.hashCode();
    }
}
