package com.yidianling.uikit.business.session.view

import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.ydl.ydlcommon.utils.Utils
import com.yidianling.im.R

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/12/11
 */
class CollectInfoStyleAdapter(var list: List<String>, var event: (title: String) -> Unit) : RecyclerView.Adapter<CollectInfoStyleAdapter.InfoStyleHolder>() {
    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): InfoStyleHolder {
        return InfoStyleHolder(LayoutInflater.from(parent!!.context).inflate(R.layout.im_item_collect_info_question_style, parent, false))
    }

    override fun getItemCount(): Int {
        return if (list.size > 9) 9 else list.size
    }

    override fun onBindViewHolder(holder: InfoStyleHolder, position: Int) {
        holder.bindData(list[position])
        holder.itemView.setOnClickListener {
            if (Utils.isFastClick()) {
                //防止连击
                return@setOnClickListener
            }
            event(list[position])
        }
    }

    inner class InfoStyleHolder(var view: View) : RecyclerView.ViewHolder(view) {
        private var textView: TextView = view.findViewById(R.id.tv_title)

        fun bindData(title: String) {
            textView.text = title
        }
    }
}