package com.yidianling.uikit.business.session.view

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.ViewGroup
import com.yidianling.uikit.custom.http.response.CommonQuestionBean

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/12/9
 */
class CommonQuestionAdapter(var mContext: Context, var list: List<CommonQuestionBean>, var event: (title: String, id: String) -> Unit) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return CommonQuestionViewHolder(CommonQuestionItemView(mContext))
    }

    override fun getItemCount(): Int {
        return list.size
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        ((holder as CommonQuestionViewHolder).itemView as CommonQuestionItemView).setData(list[position].title, list[position].keyword, position == list.size - 1)
        holder.itemView.setOnClickListener {
            event(list[position].title, list[position].id)
        }
    }

    inner class CommonQuestionViewHolder(view: CommonQuestionItemView) : RecyclerView.ViewHolder(view)
}