package com.yidianling.uikit.business.session.viewholder;

import android.text.method.LinkMovementMethod;
import android.text.style.ImageSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.nimbase.business.session.emoji.MoonUtil;
import com.yidianling.uikit.business.session.helper.TeamNotificationHelper;
import com.yidianling.nimbase.common.ui.recyclerview.adapter.BaseMultiItemFetchLoadAdapter;

public class MsgViewHolderNotification extends MsgViewHolderBase {

    public MsgViewHolderNotification(BaseMultiItemFetchLoadAdapter adapter) {
        super(adapter);
    }

    protected TextView notificationTextView;
    protected ImageView ivLabel;

    @Override
    protected int getContentResId() {
        return R.layout.im_nim_message_item_notification;
    }

    @Override
    protected void inflateContentView() {
        notificationTextView = (TextView) view.findViewById(R.id.message_item_notification_label);
        ivLabel = view.findViewById(R.id.iv_label);

    }

    @Override
    protected void bindContentView() {
        handleTextNotification(getDisplayText());
    }

    protected String getDisplayText() {
        return TeamNotificationHelper.getTeamNotificationText(message, message.getSessionId());
    }

    private void handleTextNotification(String text) {
        MoonUtil.identifyFaceExpressionAndATags(context, notificationTextView, text, ImageSpan.ALIGN_BOTTOM);
        notificationTextView.setMovementMethod(LinkMovementMethod.getInstance());
        if (getDisplayText().contains("群聊已结束")){
            ivLabel.setVisibility(View.VISIBLE);
        }else {
            ivLabel.setVisibility(View.GONE);
        }

    }

    @Override
    protected boolean isMiddleItem() {
        return true;
    }
}

