package com.yidianling.uikit.custom.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.yidianling.im.bean.BusyBean
import com.yidianling.im.bean.CanViewConsult
import com.yidianling.im.bean.FirstQuestionBean
import com.yidianling.uikit.custom.http.response.*
import com.yidianling.uikit.custom.http.response.question.QuestionsInfoBean
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * Created by xj on 2019/6/26.
 */
interface ServiceApi {
    //获取专家状态信息
    @GET("chat/status")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getDoctorChatStatus(@Query("doctorUid") doctorUid: Long): Observable<BaseAPIResponse<ChatStatusBean>>

    //获取专家状态信息
    @GET("chat/assistant-online-status")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getAssistantChatStatus(@Query("assistantUid") assistantUid: Long): Observable<BaseAPIResponse<Int>>


    //获取推荐专家列表信息
    @GET("doctor/recommendSimilarListeners")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getRecommendExpertList(
        @Query("doctorUid") doctorUid: Long, @Query("catName") catName: String, @Query(
            "limit"
        ) limit: Int
    ): Observable<BaseAPIResponse<ArrayList<RecommendExpertBean>>>

    //获取常用语
    @POST("phrase/list")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getCommonQuestionList(): Observable<BaseAPIResponse<List<CommonQuestionBean>>>

    //常用语的点击
    @GET("phrase/count")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun sendCommonQuestionCount(@Query("id") id: String): Observable<BaseAPIResponse<Any>>


    //信息采集的问题
    @GET("user/collect/list")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun userCollectList(): Observable<BaseAPIResponse<List<UserQuestInfoBean>>>


    //获取新用户收集的信息
    @POST("user/getNewUserMes")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getNewUserMes(@Body body: RequestBody): Observable<BaseAPIResponse<List<UserQuestInfoBean>>>

    //获取用户来源的信息
    @GET("user/getExChannel")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getUserSource(@Query("uid") uid: String): Observable<BaseAPIResponse<String>>

    //信息采集的问题
    @POST("user/collect/submit")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun submitUserCollect(@Body body: RequestBody): Observable<BaseAPIResponse<Any>>

    //关注
    @GET("consult/expert-page/toggle-follow")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun focus(
        @Query("doctorId") doctorId: String,
        @Query("status") status: String
    ): Observable<BaseAPIResponse<Any>>

    //服务列表
    @GET("consult/expert-page/nproducts")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun serviceList(@Query("doctorId") doctorId: String): Observable<BaseAPIResponse<List<ServiceItemBean>>>

    //查询咨询师是否在繁忙状态
    @GET("counselor/doctor/v1/doctor/isBusy")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun queryDoctorIsBusy(@Query("id") doctorId: String): Observable<BaseAPIResponse<BusyBean>>

    //获取输入框的hint内容
    @GET("systemconfig/get-chat-view-config")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getChatViewConfig(): Observable<BaseAPIResponse<SystemInfoBean>>


    //获取代运营关联的专家的信息
    @GET("chat/get-source-doctor")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)

    //注意：这个接口返回的还有很多字段，但是暂时不需要，就先取这两个字段
    fun getSourceDoctor(
        @Query("scene") scene: Int,
        @Query("userUid") userUid: String,
        @Query("assistantUid") assistantUid: String
    ): Observable<BaseAPIResponse<SourceDoctorInfoBean>>

    //新版前置信息收集 客户端灵犀信息收集卡题库
    @GET("cms/exam/api/v1/exams/lingxi/pre-exam-question-paper")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    //注意：这个接口返回的还有很多字段，但是暂时不需要，就先取这两个字段
    fun preExamQuestionPaper(): Observable<BaseAPIResponse<QuestionsInfoBean>>

    //创建答题信息
    @POST("cms/exam/api/v1/exams")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun createEexams(@Body body: RequestBody): Observable<BaseAPIResponse<String>>

    //答题
    @POST("cms/exam/api/v1/exams/{id}/lingxi/answer-question")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun answerQuestion(@Path("id") id: String, @Body body: RequestBody): Observable<BaseAPIResponse<String>>

    /**
     * 获取首问语
     */
    @POST("dmp/v1/clouddata/schemas/lingxi_quick_replies/query")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA,"X-App-Id: crm_cloud")
    fun getFirstQuestion( @Body map: Map<String,@JvmSuppressWildcards Any>): Observable<BaseAPIResponse<FirstQuestionBean>>

    //倾诉2.0迭代   是否显示立即咨询按钮
    @GET("consult/expert-page/canViewConsult")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun canViewConsult(@Query("doctorId") doctorId: String): Observable<BaseAPIResponse<CanViewConsult>>


}