package com.yidianling.uikit.custom.http

import com.alibaba.fastjson.JSON
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.im.bean.BusyBean
import com.yidianling.im.bean.CanViewConsult
import com.yidianling.im.bean.FirstQuestionBean
import com.yidianling.im.http.ImRetrofitApi
import com.yidianling.uikit.custom.http.response.*
import com.yidianling.uikit.custom.http.response.question.QuestionsInfoBean
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * Created by xj on 2019/6/26.
 */
class ServiceImpl private constructor() {

    companion object {
        val instance by lazy { ServiceImpl() }
    }

    /**
     * 获取专家登录状态
     */
    fun getDoctorChatStatus(doctorUid: Long): Observable<BaseAPIResponse<ChatStatusBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getDoctorChatStatus(doctorUid)
    }

    /**
     * 获取助理登录状态
     */
    fun getAssistantChatStatus(assistantUid: Long): Observable<BaseAPIResponse<Int>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getAssistantChatStatus(assistantUid)
    }

    /**
     * 获取推荐专家列表
     */
    fun getRecommendExpertList(
        doctorUid: Long,
        catName: String,
        limit: Int
    ): Observable<BaseAPIResponse<ArrayList<RecommendExpertBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java)
            .getRecommendExpertList(doctorUid, catName, limit)
    }

    /**
     * 获取常用语
     */
    fun getCommonQuestionList(): Observable<BaseAPIResponse<List<CommonQuestionBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getCommonQuestionList()
    }

    /**
     * 常用语的点击
     */
    fun sendCommonQuestionCount(id: String): Observable<BaseAPIResponse<Any>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).sendCommonQuestionCount(id)
    }

    /**
     * 信息采集的问题
     */
    fun userCollectList(): Observable<BaseAPIResponse<List<UserQuestInfoBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).userCollectList()
    }

    /**
     * 信息采集的问题新版
     */
    fun preExamQuestionPaper(): Observable<BaseAPIResponse<QuestionsInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).preExamQuestionPaper()
    }

    /**
     * 获取新用户收集的信息
     */
    fun getNewUserMes(bean: NewUserMesBean): Observable<BaseAPIResponse<List<UserQuestInfoBean>>> {
        val beanStr = JSON.toJSONString(bean)
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            beanStr
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getNewUserMes(body)
    }

    /**
     * 获取用户来源
     */
    fun getUserSourceFrom(uid: String): Observable<BaseAPIResponse<String>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getUserSource(uid)
    }

    /**
     * 上传采集的问题
     */
    fun submitUserCollect(params: String): Observable<BaseAPIResponse<Any>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).submitUserCollect(body)
    }

    /**
     * 关注用户
     */
    fun focus(doctorId: String, status: String): Observable<BaseAPIResponse<Any>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).focus(doctorId, status)
    }

    /**
     * 服务列表
     */
    fun serviceList(doctorId: String): Observable<BaseAPIResponse<List<ServiceItemBean>>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).serviceList(doctorId)
    }

    /**
     * 查询咨询师是否在繁忙状态
     */
    fun queryDoctorIsBusy(doctorId: String): Observable<BaseAPIResponse<BusyBean>>{
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).queryDoctorIsBusy(doctorId)
    }

    /**
     * 获取输入框的hint内容
     */
    fun getChatViewConfig(): Observable<BaseAPIResponse<SystemInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getChatViewConfig()
    }


    /**
     * 客户端灵犀信息收集卡题库
     */
    fun getSourceDoctor(
        userUid: String,
        assistantUid: String
    ): Observable<BaseAPIResponse<SourceDoctorInfoBean>> {
        return YDLHttpUtils.obtainApi(ServiceApi::class.java)
            .getSourceDoctor(1, userUid, assistantUid)
    }

    /**
     * 创建答题信息
     */
    fun createEexams(params: String): Observable<BaseAPIResponse<String>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).createEexams(body)
    }

    /**
     * 回答问题
     */
    fun answerQuestion(id: String, params: String): Observable<BaseAPIResponse<String>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).answerQuestion(id, body)
    }

    /**
     * 去聊天 回答问题
     */
    fun lingxiAnswerQuestion(params: String): Observable<BaseAPIResponse<Any>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ImRetrofitApi::class.java).lingxiAnswerQuestion(body)
    }

    /**
     * 去聊天批量发送 回答问题
     */
    fun batchSendCustomizeMessage(params: String): Observable<BaseAPIResponse<Any>> {
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            params
        ) as RequestBody
        return YDLHttpUtils.obtainApi(ImRetrofitApi::class.java).batchSendCustomizeMessage(body)
    }

    /**
     * 获取首问语
     */
    fun getFirstQuestion(): Observable<BaseAPIResponse<FirstQuestionBean>> {
        val filterMap = HashMap<String,Any>()
        filterMap["type"] = 1
        val map = HashMap<String,Any>()
        map["filter"] = filterMap
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).getFirstQuestion(map)
    }

    /**
     * 是否显示立即咨询
     */
    fun canViewConsult(doctorId: String):Observable<BaseAPIResponse<CanViewConsult>>{
        return YDLHttpUtils.obtainApi(ServiceApi::class.java).canViewConsult(doctorId)
    }

}