package com.yidianling.uikit.custom.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_user_info_dialog_layout.*

/**
 * 用户信息弹窗
 * Created by xj on 2020/3/25.
 */
class UserInfoDialog(
    private val mContext: Context,
    private val sourceFrom: String, //来源
    private val age: String, //年龄
    private val sex: String, //性别
    private val consultType: String, //咨询类型
    private val questionDes: String //问题描述
) : Dialog(mContext, R.style.dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_user_info_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.CENTER)
        window.attributes = params

        if (!TextUtils.isEmpty(sourceFrom)) {
            user_info_dialog_sourceFrom.visibility = View.VISIBLE
            user_info_dialog_sourceFrom_tv.text = sourceFrom
        }

        user_info_dialog_age_tv.text = age
        user_info_dialog_sex_tv.text = sex
        user_info_dialog_consultType_tv.text = consultType
        user_info_dialog_questionDes_tv.text = questionDes

        user_info_dialog_close.setOnClickListener {
            if (null != mContext) {
                dismiss()
            }
        }
    }
}