package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.view.View
import android.widget.LinearLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.im.R
import com.yidianling.im.config.constants.ImConstants
import com.yidianling.im.router.ImIn
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import com.yidianling.user.api.service.IUserService
import kotlinx.android.synthetic.main.im_expert_consult_service_item_view.view.*
import java.text.DecimalFormat

/**
 * 咨询服务， 预约item
 * */
class ExpertConsultServiceItemView : LinearLayout {


    constructor(context: Context, listener: ConsultServiceViewCallback?, isBusy: Boolean) : super(
        context
    ) {
        mListener = listener
        mContext = context
        mIsBusy = isBusy

        initView()
    }

    private var mContext: Context? = null
    private var mListener: ConsultServiceViewCallback? = null
    private var mIsBusy: Boolean = false


    private fun initView() {

        val mWidth: Int = LayoutParams.MATCH_PARENT
        val mHeight: Int = LayoutParams.WRAP_CONTENT

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        orientation = HORIZONTAL
        View.inflate(mContext, R.layout.im_expert_consult_service_item_view, this)
    }


    fun updateBusyStatus(isBusy: Boolean) {
        mIsBusy = isBusy
        if (mIsBusy) {
            im_expert_service_list_btn.visibility = View.GONE
            tv_add.visibility = View.VISIBLE
            tv_add.setOnClickListener {
                mListener?.addTime()
            }
        } else {
            im_expert_service_list_btn.visibility = View.VISIBLE
            tv_add.visibility = View.GONE
        }
    }

    /**
     * 设置数据
     */
    @SuppressLint("SetTextI18n")
    fun setData(bean: ServiceItemBean.ProductsBean) {
        if (mIsBusy) { // 是否繁忙 true繁忙
            im_expert_service_list_btn.visibility = View.GONE
            tv_add.visibility = View.VISIBLE
            tv_add.setOnClickListener {
                mListener?.addTime()
            }
        } else {
            im_expert_service_list_btn.visibility = View.VISIBLE
            tv_add.visibility = View.GONE

        }
        //是否是套餐
        if (bean.productDto.isPackage == 2) {
            //展示左上角套餐布局
            service_item_package.visibility = View.VISIBLE
            //服务名
            service_item_title.text = "       ${bean.productDto.name}"
            //起售次数展示
            service_item_low_buy_time.visibility = View.VISIBLE
            service_item_low_buy_time.text = "(${bean.productDto.packageNum}次起售)"
        } else {
            //隐藏套餐布局
            service_item_package.visibility = View.GONE
            //服务名
            service_item_title.text = bean.productDto.name ?: ""
            //隐藏起售次数限制
            service_item_low_buy_time.visibility = View.GONE
        }

        val mCompare: Comparator<ServiceItemBean.ProductsBean.ProductSpecDtosBean> =
            Comparator { o1, o2 ->
                val res = o1.price.compareTo(o2.price)
                when {
                    res == 0 -> 0
                    res > 0 -> -1
                    else -> 1
                }
            }
        if (bean.productSpecDtos != null && bean.productSpecDtos.size > 0) {
            val mBean: ServiceItemBean.ProductsBean.ProductSpecDtosBean =
                bean.productSpecDtos.sortedWith(mCompare).last()
            //价格，取productSpecDtos数组最小价格，不保留小数
//            service_item_price.text = String.format(
//                "%.0f",
//                mBean.price
//            )
            val decimalFormat = DecimalFormat("###.##")
            service_item_price.text = decimalFormat.format(mBean.price)
            service_item_price.paint.isFakeBoldText = true

            //时间，取productSpecDtos数组最后一个的时间
//            service_item_time.text = "/${bean.productDto.minOrderTime}分钟"
        }

        //好评率，*20后 保留1位小数
        service_item_feddbackrate.visibility = VISIBLE
        tv_feedbackRate.visibility = VISIBLE

        if (bean.productDto.feedbackRate > 0) { // 好评率大于0才展示出来，否则隐藏
            //好评率，*20后 保留1位小数
            service_item_feddbackrate.visibility = VISIBLE
            tv_feedbackRate.visibility = VISIBLE

            service_item_feddbackrate.text = String.format(
                "%.1f",
                (bean.productDto.feedbackRate) * 100f
            ) + "%"
        } else {
            service_item_feddbackrate.visibility = GONE
            tv_feedbackRate.visibility = GONE
        }


        //销量
//        service_item_saleout_num.text = "销量${bean.productDto.saleAmount}"
        service_item_saleout_num.text = "${bean.productDto.saleAmount}"

        setOnClickListener {
            mListener?.onItemClick(bean)
        }

        im_expert_service_list_btn.setOnClickListener {
            mContext?.let {context ->
                if (!ImIn.loginByOneKeyLogin(context, true)) {
                    return@setOnClickListener
                }
            }

            if (ImIn.getUserService().isBindPhone()) {
                NewH5Activity.start(
                    mContext,
                    H5Params(
                        HttpConfig.MH5_URL + "consult/#/pages/jieyou/DownOrder?product_id=${bean.productDto.id}&hideNavBar=1",
                        null
                    )
                )
            } else {
                //新增需求，如果没有绑定手机号，跳转到绑定手机号页面
                bindPhoneDialog()
            }
            ActionCountUtils.record(
                "ydl_experts_detail",
                "booking_product_popup_page_click",
                "",
                "2"
            )
        }

    }

    fun bindPhoneDialog() {
        CommonDialog(mContext)
            .setCancelAble(false)
            .setMessage(ImConstants.TEL_BINDPHONE)
            .setLeftOnclick("忍痛放弃", null)
            .setRightClick("果断绑定") { view ->
                try {
                    ModularServiceManager.provide(IUserService::class.java)
                        .wxBindToInputhonePage(mContext as Activity)
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
            .show()
    }
}