package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.viewpager.widget.PagerAdapter
import com.netease.nimlib.sdk.NIMClient
import com.netease.nimlib.sdk.RequestCallback
import com.netease.nimlib.sdk.msg.MessageBuilder
import com.netease.nimlib.sdk.msg.MsgService
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.im.R
import com.yidianling.im.session.extension.CustomAttachSubScriptTime
import com.yidianling.uikit.business.session.helper.MessageListPanelHelper
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import kotlinx.android.synthetic.main.im_expert_consult_service_list_dialog_layout.*

/**
 * 专家咨询服务列表弹框
 * Created by xj on 2019/8/7.
 *
 * @param mIsBusy 咨询师是否是繁忙状态
 */
class ExpertConsultServiceListDialog(val mContext: Context, val mList: List<ServiceItemBean>,val mIsBusy: Boolean,
                                     val toUid:String,val doctorID:String): Dialog(mContext, R.style.dialog_default_style) {

    private var mConsultServiceListView: ExpertConsultServiceView? = null
    private var mWebviewView: ExpertConsultWebview? = null
    private var mViewList: ArrayList<View> = ArrayList()
    private var mSelectType: String = "全部"
    fun changeItem(){
     dialog_bottom_scroll_view.currentItem = 0
    }
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.im_expert_consult_service_list_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = RxDeviceTool.getScreenHeight(mContext) - RxImageTool.dp2px(100f)
        params.gravity = Gravity.BOTTOM
        window.setWindowAnimations(R.style.bottom_to_top_dialog_style)
        window.attributes = params

        var typeList:ArrayList<String> = ArrayList()
        typeList.add(mSelectType)//默认选中
        mList.forEach { item ->
            typeList.add(item.cateName)
        }

        mConsultServiceListView = ExpertConsultServiceView(mContext,mIsBusy)

        (mConsultServiceListView as ExpertConsultServiceView).setDataAndClick(typeList, mList, object : ConsultServiceViewCallback {
            override fun onCloseClick() {
                dismiss()
            }

            override fun onItemClick(serviceBean: ServiceItemBean.ProductsBean) {
//                if (mConsultServiceDetailView != null) {
//                    mConsultServiceDetailView?.updateData(serviceBean)
//                    dialog_bottom_scroll_view.currentItem = 1
//                }

                mWebviewView?.setData(serviceBean)
                dialog_bottom_scroll_view.currentItem = 1
            }

            override fun addTime() { // 提醒添加时间回调
                dismiss()
                // 埋点
                ActionCountUtils.baiDuCountSign3(
                    "ydl_user_product_page",
                    "remind_add_click",
                    toUid,
                    ActionHandlerStorage.getL(toUid).info.name,
                    ""
                )
                // 发送提醒消息
                val customTime = CustomAttachSubScriptTime("我想预约服务，请尽快开启服务时间")
                val message = MessageBuilder.createCustomMessage(
                    toUid,
                    SessionTypeEnum.P2P,
                    "我想预约服务，请尽快开启服务时间",
                    customTime
                )
                NIMClient.getService(MsgService::class.java).sendMessage(message, false)
                    .setCallback(object :
                        RequestCallback<Void> {
                        override fun onSuccess(param: Void?) {
                            MessageListPanelHelper.getInstance().notifyAddMessage(message)
                        }

                        override fun onException(exception: Throwable?) {

                        }

                    override fun onFailed(code: Int) {


                    }
                })
            }
        })

        mViewList.add(mConsultServiceListView as View)

//        mConsultServiceDetailView = ExpertConsultServiceDetailView(mContext, object : ConsultServiceViewCallback {
//                    override fun onBackClick() {
//                        dialog_bottom_scroll_view.currentItem = 0
//                    }
//                },mIsBusy,toUid)

//        mViewList.add(mConsultServiceDetailView as View)
        mWebviewView= ExpertConsultWebview(mContext,doctorID =doctorID )
        mViewList.add(mWebviewView as View)

        dialog_bottom_scroll_view.adapter = ConsultServicePagerAdapter()
        dialog_bottom_scroll_view.currentItem = 0

        setCanceledOnTouchOutside(true)
    }

    internal inner class ConsultServicePagerAdapter : PagerAdapter() {

        override fun getCount(): Int {
            return mViewList.size
        }

        override fun isViewFromObject(view: View, `object`: Any): Boolean {
            return view === `object`
        }

        override fun instantiateItem(container: ViewGroup, position: Int): Any {
            val view = mViewList[position]
            container.addView(view)
            return view
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }
    }
}