package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.im.R
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import kotlinx.android.synthetic.main.im_expert_consult_service_view.view.*

class ExpertConsultServiceView : LinearLayout {

    private var typeSelectedIndex: Int = 0
    private var mTypeList: ArrayList<String> = ArrayList()
    private var mServiceList: ArrayList<ServiceItemBean> = ArrayList()

    private var mListener: ConsultServiceViewCallback? = null
    private var mIsBusy = false

    val mCompare: Comparator<ServiceItemBean.ProductsBean> = Comparator { o1, o2 ->
        val res = o1.productDto.sortOrder.compareTo(o2.productDto.sortOrder)
        when {
            res == 0 -> 0
            res > 0 -> -1
            else -> 1
        }
    }

    constructor(context: Context,isBusy: Boolean) : super(context) {
        mContext = context
        mIsBusy = isBusy
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {
        val mWidth: Int = RxDeviceTool.getScreenWidth(mContext)
        val mHeight: Int = LayoutParams.MATCH_PARENT

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        orientation = VERTICAL
        View.inflate(mContext, R.layout.im_expert_consult_service_view, this)
    }

    fun setBusyStatus(isBusy: Boolean){
        this.mIsBusy = isBusy
        for(i in 0 until  expert_consult_service_service_list.childCount){
            val view = expert_consult_service_service_list.getChildAt(i)
            if (view is ExpertConsultServiceItemView) {
                view.updateBusyStatus(mIsBusy)
            }
        }
    }
    /**
     * typeList 类型列表
     * serviceList 服务列表
     */
    fun setDataAndClick(
        typeList: ArrayList<String>,
        allServiceList: List<ServiceItemBean>,
        listener: ConsultServiceViewCallback?
    ) {
        mListener = listener
//        consult_service_dialog_close.setOnClickListener {
//            mListener?.onCloseClick()
//        }

        // 设置顶部滚动类型数据
        if (typeList == null || typeList.size == 0) {
            expert_consult_service_top_scroll.visibility = View.GONE
        } else {
            mTypeList.clear()
            mTypeList.addAll(typeList)
            mContext?.let {
                mTypeList.forEachIndexed { index, str ->
                    val item = ExpertConsultServiceTypeItemView(mContext!!)
                    item.setData(str, index == typeSelectedIndex)
                    item.setOnClickListener {
                        typeSelectedIndex = index
                        resetSelected()
                        selectTypeServiceList()
                    }
                    expert_consult_service_type_list.addView(item)
                }
            }
        }
        tv_title.paint.isFakeBoldText = true
        typeSelectedIndex = 0 // 初始化为全部选中
        mServiceList.clear()
        mServiceList.addAll(allServiceList)
        // 设置服务列表数据
        selectTypeServiceList()
    }

    /**
     * 刷新服务列表数据
     */
    private fun selectTypeServiceList() {
        expert_consult_service_service_list.removeAllViews()
        if (mServiceList.size != 0) {
            val lastList: ArrayList<ServiceItemBean.ProductsBean> = ArrayList()
            mServiceList.forEachIndexed { index, itemBean ->
                //当选中String相同的时候，添加view，或者选中typeSelectedIndex==0的时候，展示全部
                if (itemBean.cateName == mTypeList[typeSelectedIndex] || typeSelectedIndex == 0) {
                    itemBean.products.forEach {
                        lastList.add(it)
                        it.setcatenewId(itemBean.cateId)
                    }
                }
            }
           val sortedList= lastList.sortedBy { productsBean: ServiceItemBean.ProductsBean ->
                productsBean.productDto.sortIndex
            }


            sortedList.sortedWith(mCompare).forEach {
                val item = ExpertConsultServiceItemView(mContext!!, mListener,mIsBusy)
                item.setData(it)
                expert_consult_service_service_list.addView(item)
            }
        }
    }

    /**
     * 刷新类型列表数据
     */
    private fun resetSelected() {
        for (index in 0 until expert_consult_service_type_list.childCount) {
            var view = expert_consult_service_type_list.getChildAt(index)
            if (view is ExpertConsultServiceTypeItemView) {
                view.updateStatus(index == typeSelectedIndex)
            }
        }
    }
}