package com.yidianling.muse.activity

import android.content.Intent
import android.os.Bundle
import com.blankj.utilcode.util.SPUtils
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions
import com.bumptech.glide.request.RequestOptions
import com.ydl.ydlcommon.base.BaseActivity
import com.yidianling.muse.R
import jp.wasabeef.glide.transformations.BlurTransformation
import kotlinx.android.synthetic.main.activity_play_meditation_time_off.*

class MeditationTimeOffActivity : BaseActivity() {

    private lateinit var mBGImageUrl:String

    override fun onCreate(savedInstanceState: Bundle?) {

        super.onCreate(savedInstanceState)

        mBGImageUrl = intent?.getStringExtra("BG_IMAGE_URL")?:""

        initView()
    }

    private fun initView() {

        val options = RequestOptions.bitmapTransform(BlurTransformation(25,1))

        Glide.with(this)
            .load(mBGImageUrl)
            .transition(DrawableTransitionOptions.withCrossFade())
            .apply(options)
            .into(iv_bg)

        iv_close?.setOnClickListener { finish() }

        tv_save_setting?.setOnClickListener {
            val hour = wheel_hour.selectedItem
            val minute = wheel_minute.selectedItem

            val selectedHour = wheel_hour.selectedItem
            val selectedMinute = wheel_minute.selectedItem

            SPUtils.getInstance().put("SELECT_H",selectedHour)
            SPUtils.getInstance().put("SELECT_M",selectedMinute)

            val intent = Intent()
            if (hour is Int && minute is Int){
                val minute = (hour *60).plus(minute*5)
                intent.putExtra("TIME_OFF_MINUTE", minute)
            }
            setResult(RESULT_OK, intent)
            finish()
        }

        tv_cancel_time_off?.setOnClickListener {
            SPUtils.getInstance().put("SELECT_H",0)
            SPUtils.getInstance().put("SELECT_M",1)
            val intent = Intent()
            intent.putExtra("TIME_OFF_MINUTE", 0)
            setResult(RESULT_OK, intent)
            finish()
        }

        initWheel()

    }

    private fun initWheel() {
        val selectionH = SPUtils.getInstance().getInt("SELECT_H",0)
        val selectionM = SPUtils.getInstance().getInt("SELECT_M",1)

        createHours()
        createMinutes()

        wheel_hour.setItems(hours)
        wheel_minute.setItems(minutes)

        wheel_hour.setInitPosition(selectionH)
        wheel_minute.setInitPosition(selectionM)

        wheel_hour.setListener { index ->
            if (index == 0 && wheel_minute.selectedItem == 0) {
                wheel_minute.setCurrentPosition(1)
            }
        }

        wheel_minute.setListener { index ->
            if (index == 0 && wheel_hour.selectedItem == 0) {
                wheel_minute.setCurrentPosition(1)
            }
        }


    }

    override fun initDataAndEvent() {

    }

    override fun layoutResId(): Int {
        return R.layout.activity_play_meditation_time_off
    }

    private var hours = mutableListOf<String>()
    private var minutes = mutableListOf<String>()

    private fun createHours() {
        for (i in 0..23) {
            hours.add("" + i)
        }
    }

    private fun createMinutes() {
        var i = 0
        while (i < 60) {
            if (i < 10) {
                minutes.add("0$i")
            } else {
                minutes.add("" + i)
            }
            i += 5
        }
    }

}