package com.yidianling.muse.activity

import com.alibaba.android.arouter.facade.annotation.Route
import com.channel.ydl_flutter_base.base.BaseFlutterActivity
import com.ydl.media.audio.AudioPlayer
import com.ydl.ydlcommon.router.IYDLRouterConstant
import com.yidianling.muse.handler.MusePlugin
import org.json.JSONObject


/**
 * Created by xj on 2019/9/6.
 * 统一路由不要直接跳这个activity，有一个中间MuseCenterActivity
 */

@Route(path = "/module/muse")
class MuseActivity : BaseFlutterActivity() {
    override fun initialRoute(): String {
        return "muse/home"
    }

    override fun initChannelPlugin(jsonObject: JSONObject) {

        MusePlugin.rigister(this, jsonObject.getString(IYDLRouterConstant.MUSIC_URL), jsonObject.getString(IYDLRouterConstant.DATA_JSON))

        /**
         * 如果正在播放音乐，则停止播放所有音乐
         */
        if (AudioPlayer.get().isPlaying) {
            AudioPlayer.get().resetPlayer()
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        /**
         * 退出冥想模块的时候，关闭音乐播放
         */
        AudioPlayer.get().resetPlayer()
    }
}
