package com.yidianling.muse.dialog

import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.content.res.Resources
import android.net.Uri
import android.os.Bundle
import android.text.TextUtils
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import android.webkit.WebSettings
import com.ydl.utils.WebUrlParamsUtils
import com.ydl.webview.H5Params
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.muse.R
import kotlinx.android.synthetic.main.dialog_choose_music.*

/**
 * Created by Ykai on 2022/5/26.
 *
 * 选择音乐弹窗，内部是h5页面
 */
class ChooseMusicDialog(activity: Activity,h5Params: H5Params) : Dialog(activity, R.style.music_dialog_style)  {
    private val mActivity = activity
    private val h5Params: H5Params = h5Params


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        // 设置宽度全屏
        //dialog去除默认边距，宽度占满全屏
        val window = window!!
        window.setWindowAnimations(R.style.dialog_anim)
        // 把 DecorView 的默认 padding 取消，同时 DecorView 的默认大小也会取消
        window.decorView.setPadding(0, 0, 0, 0)
        val layoutParams = window.attributes
        layoutParams.gravity = Gravity.BOTTOM
        layoutParams.width = WindowManager.LayoutParams.MATCH_PARENT
        layoutParams.height = (RxDeviceTool.getScreenHeight(context)*0.89).toInt()
        window.attributes = layoutParams

        setContentView(R.layout.dialog_choose_music)

        initView()
    }

    @SuppressLint("SetJavaScriptEnabled")
    private fun initView() {
        // 移除有漏洞的系统接口
        wv_choose_music.removeJavascriptInterface("searchBoxJavaBridge_")
        wv_choose_music.removeJavascriptInterface("accessibility")
        wv_choose_music.removeJavascriptInterface("accessibilityTraversal")
        val mWebSettings: WebSettings = wv_choose_music.settings
        mWebSettings.javaScriptEnabled = true //支持js
        mWebSettings.defaultTextEncodingName = "GBK" //设置字符编码
        mWebSettings.domStorageEnabled = true
        mWebSettings.textZoom = 100 //设置字体不跟随字体变化而变化
        mWebSettings.allowFileAccessFromFileURLs = true
        mWebSettings.blockNetworkImage = false // 解决图片不显示
        mWebSettings.mixedContentMode = WebSettings.LOAD_NORMAL
        wv_choose_music.scrollBarStyle = View.SCROLLBARS_INSIDE_OVERLAY //滚动条风格，为0指滚动条不占用空间，直接覆盖在网页上
//        val jsInterface = JsInterface(mActivity as PlayMeditationActivity)
//        wv_choose_music.addJavascriptInterface(jsInterface, "javascriptHandler")

        val url = setUrlHeightParams(h5Params.url)
        wv_choose_music.loadUrl(url)

            ll_close.setOnClickListener {
                dismiss()
            }
    }


    /**
     * 专家详情页改版 需要url后面拼接状态栏高度 并且隐藏导航栏
     *
     * @param url
     * @return
     */
    private fun setUrlHeightParams(url: String): String {
        var resultUrl: String? = url
        try {
            val uri = Uri.parse(url)
            val host = uri.host
            if (!TextUtils.isEmpty(host) && host.contains("nodeapi.ydl")) {
                //马亮的需求，在nodeapi.ydl.com 地址后面拼上公共参数，用于判断是否为app
                val uriAppendSuffix = ""
                resultUrl = WebUrlParamsUtils.getSuffix(url, uriAppendSuffix)
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return pinjie(resultUrl)
    }

    private fun pinjie(jumpUrl: String?): String {
        var useUrl = StringBuffer().append(jumpUrl).toString()
        val res: Resources = mActivity.resources
        val doctorUrlArray = res.getStringArray(R.array.platform_doctorUrls)
        for (url in doctorUrlArray) {
            if (useUrl.contains(url)) {
                var lastUrl = useUrl.replace(url.toRegex(), "")
                if (lastUrl.contains("?")) {
                    lastUrl = lastUrl.substring(0, lastUrl.indexOf("?"))
                }
                try {
                    //不报错就说明可以转成long，就说明是专家详情页地址
                    lastUrl.toLong()
                    if (!lastUrl.contains("/")) {
                        if (useUrl.endsWith("?")) {
                            useUrl = useUrl.substring(0, useUrl.indexOf("?"))
                        }
                    }
                } catch (e: NumberFormatException) {
                    e.printStackTrace()
                }
            }
        }
        return useUrl
    }
}