package com.yidianling.home.http

import com.google.gson.Gson
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.muse.bean.*
import com.yidianling.muse.http.MusePagerApi
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * @author jiucheng
 * @描述:首页接口实现类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
class MuseHttp {

    companion object {
        fun getInstance(): MuseHttp {
            return Holder.INSTANCE
        }
    }

    object Holder {
        val INSTANCE = MuseHttp()
    }

    private var museApi: MusePagerApi? = null

    private fun getMusePagerApi(): MusePagerApi {
        if (museApi == null) {
            museApi = YDLHttpUtils.obtainApi(MusePagerApi::class.java)
        }
        return museApi!!
    }

    //壹点冥想
    fun newMuseRequest(): Observable<BaseAPIResponse<MuseModuleBean>> {
        return getMusePagerApi().getMuseData()
    }

    fun getPureMusicPlayDetail(
        meditionType: Int,
        meditationId: Long
    ): Observable<BaseAPIResponse<MeditationPlayModuleBean>> {
        return getMusePagerApi().getPureMusicPlayDetail(
            meditionType = meditionType,
            meditationId = meditationId
        )
    }

    fun getMeditationPlayDetail(
        meditionType: Int,
        mediaId: Long,
        meditationId: Long
    ): Observable<BaseAPIResponse<MeditationPlayModuleBean>> {
        return getMusePagerApi().getMeditationPlayDetail(
            meditionType = meditionType,
            mediaId = mediaId,
            meditationId = meditationId
        )
    }

    fun collectMeditation(
        meditationId: Long,
        mediaId: Long,
        status: Int,
        businessType: Int
    ): Observable<BaseAPIResponse<CollectResultModule>> {
        val params = MeditationCollectRequestModule(
            meditationId = meditationId,
            mediaId = mediaId,
            status = status,
            businessType = businessType
        )
        var str = Gson().toJson(params)
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            str
        ) as RequestBody
        return RxUtils.mapObservable(params).flatMap { getMusePagerApi().collectMeditation(body) }
    }

    fun postMeditationPlayRecord(
        meditationId: Int,
        isQuit: Int,
        mediaId: Long,
        playTime: Int, isComplete: Int
    ): Observable<BaseAPIResponse<MeditationPlayRecordResponseModule>> {
        val params = MeditationPlayRecordRequestModule(
            meditationId = meditationId,
            isQuit = isQuit, mediaId = mediaId, playTime = playTime, isComplete = isComplete
        )
        var str = Gson().toJson(params)
        val body = RequestBody.create(
            MediaType.parse("application/json; charset=utf-8"),
            str
        ) as RequestBody
        return RxUtils.mapObservable(params)
            .flatMap { getMusePagerApi().meditationPlayRecord(body) }
    }


}