package com.yidianling.muse.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.muse.bean.*
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * @author jiucheng
 * @描述:首页接口api
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/22
 */
interface MusePagerApi {

    //壹点 - 冥想
    @GET("meditation/meditation/list")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getMuseData(): Observable<BaseAPIResponse<MuseModuleBean>>


    /**
     * 声音播放详情页
     */
    @GET("cms/meditation/meditationPlayDetail")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getPureMusicPlayDetail(
        @Query("meditionType") meditionType: Int = 0,
        @Query("meditationId") meditationId: Long
    ): Observable<BaseAPIResponse<MeditationPlayModuleBean>>

    /**
     * 冥想播放详情页
     */
    @GET("cms/meditation/meditationPlayDetail")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getMeditationPlayDetail(
        @Query("meditionType") meditionType: Int = 1,
        @Query("mediaId") mediaId: Long,
        @Query("meditationId") meditationId: Long
    ): Observable<BaseAPIResponse<MeditationPlayModuleBean>>

    /**
     * 收藏和取消收藏
     */
    @POST("cms/meditation/collect")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json")
    fun collectMeditation(@Body body: RequestBody): Observable<BaseAPIResponse<CollectResultModule>>

    /**
     * 冥想播放记录
     */
    @POST("cms/meditation/playRecord")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA,"Content-Type:application/json")
    fun meditationPlayRecord(@Body body: RequestBody
    ): Observable<BaseAPIResponse<MeditationPlayRecordResponseModule>>



}