package com.yidianling.muse.utils

import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.yidianling.home.http.MuseHttp
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

class MediaPlayerTimeUtil {

    companion object{

        fun calculateTime(time:Int):String?{
            var minute = 0
            var second = 0
            if (time>60){
                minute = time / 60
                second = time % 60
                return if (minute in 0..9){
                    if (second in 0..9){
                        "0$minute:0$second"
                    }else{
                        "0$minute:$second"
                    }
                }else{
                    if (second in 0..9){
                        "$minute:0$second"
                    }else{
                        "$minute:$second"
                    }
                }
            }else if (time in 0..59){
                second = time
                return if (second in 0..9){
                    "00:0$second"
                }else{
                    "00:$second"
                }
            }
            return ""
        }

        fun formatTimeOff(finishTime:Long):String{

            var totalTime = (finishTime / 1000).toInt() //秒

            var minute = 0
            var second = 0

            if (60 <= totalTime) {
                minute = totalTime / 60
                totalTime -= 60 * minute
            }
            if (0 <= totalTime) {
                second = totalTime
            }
            val sb = StringBuilder()

            if (minute < 10) {
                sb.append("0").append(minute).append(":")
            } else {
                sb.append(minute).append(":")
            }
            if (second < 10) {
                sb.append("0").append(second)
            } else {
                sb.append(second)
            }
            return sb.toString()

        }

        fun uploadPlayRecord(meditationId:Int?,mediaId:Long?,
            isQuit:Int,playTime:Int,isComplete:Int){
            if (meditationId != null && mediaId != null) {
                MuseHttp.getInstance().postMeditationPlayRecord(
                    meditationId = meditationId!!.toInt(),
                    isQuit = isQuit, mediaId = mediaId!!,
                    playTime = playTime,
                    isComplete = isComplete
                )
                    .subscribeOn(Schedulers.io())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe({

                    }, {
                        object : ThrowableConsumer() {
                            override fun accept(msg: String) {

                            }
                        }
                    })
            }
        }

    }

}