package com.yidianling.muse.widget


import android.os.Bundle
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import android.widget.TextView
import androidx.fragment.app.DialogFragment
import com.yidianling.muse.R
import com.yidianling.muse.utils.DisplayUtil


class QuitMeditationDialog : DialogFragment() {

    private var tvQuit: TextView? = null
    private var tvCancel: TextView? = null

    private var mListener:ClickListener?=null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.share_meditation_dialog)
    }

    override fun onStart() {
        super.onStart()
        val displayMetrics = DisplayMetrics()
        activity?.windowManager?.defaultDisplay?.getMetrics(displayMetrics)
        val window = dialog?.window
        window?.setGravity(Gravity.CENTER)
        window?.setLayout(DisplayUtil.dp2px(displayMetrics,300F), WRAP_CONTENT)

    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {

        val view = inflater.inflate(R.layout.layout_quit_meditation, container)

        initView(view)

        return view
    }

    private fun initView(view: View?) {

        tvQuit = view?.findViewById(R.id.tv_sure_quit)
        tvCancel = view?.findViewById(R.id.tv_cancel_quit)

        tvQuit?.setOnClickListener {
            mListener?.quit()
            dismiss()
        }

        tvCancel?.setOnClickListener {
            dismiss()
        }

    }

    fun setListener(listener: ClickListener):QuitMeditationDialog{
        mListener = listener
        return this
    }

    interface ClickListener{
        fun quit() {}
    }

    companion object {
        const val TAG = "QuitMeditationDialog"

        fun newInstance(): QuitMeditationDialog {
            val args = Bundle()
            val fragment = QuitMeditationDialog()
            fragment.arguments = args
            return fragment
        }

    }

}