package com.yidianling.tests

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.tests.list.model.bean.RecommendSearchItemBean
import com.yidianling.tests.list.model.bean.TestCategory
import com.yidianling.tests.list.model.bean.TestListData
import com.yidianling.tests.list.model.bean.TestsRedPacketBean
import io.reactivex.Observable
import retrofit2.http.*


/**
 * 测试相关网络接口
 * Created by zqk on 17-11-24.
 */
interface TestRetrofitApi {


    companion object {
        var instance: TestRetrofitApi? = null
        fun getTestRetrofitApi(): TestRetrofitApi {
            if (instance == null) {
                instance = YDLHttpUtils.obtainApi(TestRetrofitApi::class.java)
            }
            return instance!!
        }

        fun clearTestRetrofitApi() {
            instance = null
        }
    }

    //获取测试分类
    @GET("test-tag/cat_all")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun fetchTestCategory(): Observable<BaseAPIResponse<MutableList<TestCategory>>>

    /**
     * 获取测评红包
     */
    @GET("auth/test-coupon/max-coupon-money")
    @Headers( YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun fetchMaxCoupon(@Query("uid") uid: String = ""): Observable<BaseAPIResponse<String>>

    //获取测试列表
    @FormUrlEncoded
    @POST("ceshi/list")
    fun fetchTestList(@FieldMap params: Map<String, String>): Observable<BaseResponse<TestListData>>

    @GET("test-item/top-search")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun fetchTopSearch(): Observable<BaseAPIResponse<MutableList<RecommendSearchItemBean>>>

    //获取测试列表 - NEW
    @GET("test-item/list-by-cate")
    @Headers( YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    fun fetchTestListByTag(
            //测试标签ID
            @Query("testCateId") testTagId:String,
            //筛选条件免费付费 2免费 3付费
            @Query("testPrice") testPrice:String = "",
            //筛选条件测试人数 条件4
            @Query("testVisitNum") testVisitNum:String = "",
            //筛选条件创建时间 条件5
            @Query("testCreateTime") testCreateTime:String = "",
            //是否仅付费题 0全部 1仅付费
            @Query("onlyFee") onlyFee:String = "0",
            @Query("page") page: String,
            @Query("uid") uid: String = ""

    ): Observable<BaseAPIResponse<TestListData>>


    //测试详情页面跳转
    @FormUrlEncoded
    @POST("ceshi/is-answer-h5")
    fun getTestDetailJumpType(@FieldMap params: Map<String, String>): Observable<BaseResponse<String>>

    //用户最近聊天专家
    @FormUrlEncoded
    @POST("sms/recent")
    fun getRecentExpertList(@FieldMap params: Map<String, String>): Observable<BaseResponse<List<Recent>>>


    //获取用户所有测试红包列表，按优惠金额倒序排序
    @FormUrlEncoded
    @POST("ceshi/coupon")
    fun getCoupon(@FieldMap params: Map<String, String>): Observable<BaseResponse<ArrayList<TestsRedPacketBean>>>
}