package com.yidianling.tests.home.contract

import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.tests.home.bean.TestHomeDataBean
import io.reactivex.Observable

/**
 * @author yuanwai
 * @描述:测试首页约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
interface ITestHomeContract{
    //View接口
    interface View : IView {
        /**
         * 测评首页数据请求
         */
        fun newHomeRequest()

        /**
         * 测评首页数据请求结果
         */
        fun newHomeResponse(datalist : List<TestHomeDataBean>)

        /**
         * 测评首页数据请求失败
         */
        fun newHomeRequestFail()

        /**
         * 每日精选 换一批
         */
        fun dailyChange()

        /**
         * 测评首页换一批请求结果
         */
        fun dailyChangeResponse(dataBean : TestHomeDataBean)
        /**
         * 加载更多
         */
        fun loadMoreResponse(datalist : List<TestHomeDataBean>)

        /**
         * 显示错误信息
         */
        fun showError(msg : String?)
    }

    interface Presenter : IPresenter<View> {
        /**
         * 测评首页数据请求
         */
        fun newHomeRequest()

        /**
         * 上拉加载更多
         */
        fun onLoadMore(page : Int)

        /**
         * 每日精选 换一批
         */
        fun dailyChange()
    }

    interface Model: IModel {
        /**
         * 测评首页数据请求
         */
        fun newHomeRequest() : Observable<List<TestHomeDataBean>>

        /**
         * 每日精选 换一批
         */
        fun dailyChange() : Observable<TestHomeDataBean>
    }
}