package com.yidianling.tests.home.widget

import android.content.Context
import android.view.View
import android.widget.HorizontalScrollView
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.event.ITestHomeEvent
import kotlinx.android.synthetic.main.tests_testhome_dailyhorizo_view.view.*

/**
 * @author yuanwai
 * @描述:测评首页--每日精选横向滚动父View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/1
 */
class TestHomeDailyHorizoView(mContext: Context, testHomeEvent: ITestHomeEvent) : HorizontalScrollView(mContext) {

    private var testHomeEvent: ITestHomeEvent? = null
    var couponMoney  = ""

    init {
        this.testHomeEvent = testHomeEvent
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.tests_testhome_dailyhorizo_view, this)
        isVerticalScrollBarEnabled = false
        isHorizontalScrollBarEnabled = false
    }

    /**
     * 设置数据
     */
    fun initData(list: List<TestHomeBodyBean>) {
        var index = 0
        for (item in list) {
            if (index >= ll_root.childCount) {
                if (index == list.size - 1) {
                    //如果没创建 就创建view并赋值
                    ll_root.addView(TestHomeDailyHorizoItemView(context, testHomeEvent!!, true))
                } else {
                    //如果没创建 就创建view并赋值
                    ll_root.addView(TestHomeDailyHorizoItemView(context, testHomeEvent!!, false))
                }
            }
            //如果view已创建 那就重新赋值
            var childView = ll_root.getChildAt(index)
            if (childView is TestHomeDailyHorizoItemView) {
                childView.couponMoney = this.couponMoney
                childView.initData(item, index)
            }
            index++
        }
        //如果本次数据小于上一次的数据 那就将多余的View 隐藏掉
        if (index < childCount) {
            for (i in index..childCount) {
                getChildAt(i).visibility = View.GONE
            }
        }
    }
}