package com.yidianling.tests.home.widget

import android.content.Context
import android.graphics.Color
import android.text.Html
import android.text.TextUtils
import android.view.View
import android.widget.RelativeLayout
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.event.ITestHomeEvent
import com.yidianling.tests.home.utils.TestHomeUtils
import kotlinx.android.synthetic.main.tests_testhome_recommended_view.view.*

/**
 * @author yuanwai
 * @描述:测评首页--热门推荐View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/28
 */
class TestHomeRecommendedView(mContext: Context, testHomeEvent: ITestHomeEvent) : RelativeLayout(mContext) {

    private var testHomeEvent: ITestHomeEvent? = null
    var couponMoney = ""
    private var dp2 : Int? = 0
    private var dp5 : Int? = 0

    init {
        this.testHomeEvent = testHomeEvent
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.tests_testhome_recommended_view, this)
        dp2 = RxImageTool.dip2px(2f)
        dp5 = RxImageTool.dip2px(5f)
    }

    /**
     * 设置数据
     */
    fun initData(dataBean: TestHomeDataBean, position: Int) {
        if (null == dataBean || null == dataBean.body || dataBean.body.isEmpty()) {
            visibility = View.GONE
            return
        }
        //设置推荐列表数据
        initRecommeded(dataBean.body!!.get(0), position)
    }

    /**
     * 设置推荐列表数据
     */
    private fun initRecommeded(bodyBean: TestHomeBodyBean, position: Int) {
        tv_recomTitle.text = bodyBean.recommendedTitle
        tv_recomContent.text = Html.fromHtml(bodyBean.recommendedContent)
        setPrice(bodyBean.recommendedPrice)
        tv_recomNum.text = TestHomeUtils.getNum(context, bodyBean.recommendedNum)
        GlideApp.with(context).load(bodyBean.recommendedUrl)
                .placeholder(R.drawable.tests_testhome_list_nor)
                .centerCrop().into(img_recom)
        tv_Hits.text = TestHomeUtils.getHits(context, bodyBean.recommendedHits)
        setOnClickListener {
            testHomeEvent!!.recommendedClick(bodyBean.recommendedLinkUrl, position, bodyBean.recommendedTitle)
        }
    }

    private fun setPrice(price : String?){
        if (TextUtils.isEmpty(price)){
            tv_recomPrice.visibility = View.INVISIBLE
            return
        }
        tv_recomPrice.visibility = View.VISIBLE
        if ("免费" == price){
            tv_recomPrice.setPadding(dp5!!,dp2!!,dp5!!,dp2!!)
            tv_recomPrice.text = price
            tv_recomPrice.setBackgroundResource(R.drawable.tests_testhome_recom_price_bg)
            tv_recomPrice.setTextColor(Color.parseColor("#34CD65"))
            tv_coupon_money.visibility = View.GONE
        }else{
            var newPrice = TestHomeUtils.getOriginalPrice(tv_coupon_money,price,couponMoney)
            tv_recomPrice.setPadding(0,dp2!!,dp5!!,dp2!!)
            var priceContent = "￥$newPrice"
            TestHomeUtils.priceStyleNew(context,tv_recomPrice,priceContent, 1, priceContent.length)
            tv_recomPrice.setBackgroundResource(R.drawable.tests_testhome_null)
        }
    }
}