package com.yidianling.tests.list.presenter

import android.annotation.SuppressLint
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.mvp.base.SimplePresenter
import com.yidianling.tests.TestRetrofitApi
import com.yidianling.tests.list.model.bean.TestsRedPacketParam
import com.yidianling.tests.list.view.TestListActivityView
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

/**
 * TestListActivityPresenter
 * Created by zqk on 17-11-22.
 */
class TestListActivityPresenter : SimplePresenter<TestListActivityView>() {
    @SuppressLint("CheckResult")
    fun fetchTestTypeList() {
        TestRetrofitApi.getTestRetrofitApi().fetchTestCategory()
                .compose(RxUtils.applySchedulers(mView))
                .compose(RxUtils.resultJavaData())
                .subscribe({ resp ->
                        mView.onTestCategoryListFetched(resp)
                }, { t ->
                    mView.onFailed(t.message)
                })
    }

    /**
     * 请求红包列表
     */
    @SuppressLint("CheckResult")
    fun requestCoupon() {
        RxUtils.mapObservable(TestsRedPacketParam(""))
            .flatMap { TestRetrofitApi.getTestRetrofitApi().getCoupon(it) }
            .subscribeOn(Schedulers.io())
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    mView.couponResponse(it)
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
                        mView.onFailed(msg)
                    }
                })
        

    }
}