package com.yidianling.tests.modular

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.base.config.HttpConfig
import com.yidianling.tests.SelectConversationActivity
import com.yidianling.tests.api.service.ITestsApiService

/**
 * Created by haorui on 2019-10-31 .
 * Des:
 */
@Route(path = "/tests/TestsApiService")
public class TestsApiServiceImp : ITestsApiService {

    override fun init(context: Context?) {
    }

    override fun testH5Result(testResultId: String) {
        val h5Params = H5Params(HttpConfig.MH5_URL+"ceshi/result/"+testResultId, null)
        NewH5Activity.start(BaseApp.getApp(),h5Params)
    }

    override fun testDetailH5(testId: String) {
        val h5Params = H5Params(HttpConfig.MH5_URL+"ceshi/"+testId, null)
        NewH5Activity.start(BaseApp.getApp(),h5Params)
    }

    override fun getSelectConversationActivityIntent(activity: Activity, flag: Int, title: String?, head: String?, id: Int, url: String?, shareUrl: String?) : Intent {
        val intent = Intent(activity, SelectConversationActivity::class.java)
        intent.putExtra("flag", flag)
        intent.putExtra("title", title?:"")
        intent.putExtra("head", head?:"")
        intent.putExtra("id", id)
        intent.putExtra("url", url?:"")
        intent.putExtra("share_url", shareUrl?:"")
        return intent
    }
}