package com.yidianling.tests.search

import android.annotation.SuppressLint
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.mvp.base.SimplePresenter
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.tests.TestRetrofitApi
import com.yidianling.tests.home.config.TestBIConstants.Companion.TEST_MAIN_SEARCH_CONTENT_CLICK
import com.yidianling.tests.home.http.TestHomeDataManager
import com.yidianling.tests.home.param.TestHomeParam
import com.yidianling.tests.list.model.TestListCommand
import com.yidianling.tests.list.model.bean.Test
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import io.reactivex.schedulers.Schedulers

/**
 * TestSearchPresenter
 * Created by zqk on 17-12-5.
 */
class TestSearchPresenter : SimplePresenter<TestSearchView>() {

    @SuppressLint("CheckResult")
    fun fetchHotTests() {
        mView.showLoadingView()
        val cmd = TestListCommand()
        cmd.tab = "hot_test"
        cmd.page = 1
        TestRetrofitApi.getTestRetrofitApi()
                .fetchTopSearch()
                .compose(RxUtils.applySchedulers(mView))
                .subscribe({ resp ->
                    if (resp.code == "200") {
                        mView.hideNoResultView()
                        mView.onRecommendSearchListResponse(resp.data)
                    } else {
                        ToastUtil.toastShort(resp.msg)
                        mView.hideLoadingView()
                    }

                }, { throwble ->
                    HttpErrorUtils.handleError(BaseApp.getApp(), throwble)
                })
    }


    /**
     * 测评热门推荐
     */
    @SuppressLint("CheckResult")
    fun hotRecommendRequest() {
        mView.showLoadingView()
        TestHomeDataManager
                .getHttp()
                .newHomeRequest(TestHomeParam( 0))
                .compose(RxUtils.applySchedulers(mView))
                .compose(RxUtils.resultData())
                .subscribe(Consumer {
                    if (it[3].body!=null){
                        var jsonStr = Gson().toJson(it[3].body)
                        val list = Gson().fromJson<MutableList<Test>>(jsonStr, object : TypeToken<MutableList<Test>>() {
                        }.type)
                        mView.hideNoResultView()
                        mView.onHotRecommendResponse(list)
                    }else{
                        mView.hideLoadingView()
                    }
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
                        mView.showError(msg)
                    }
                })
    }

    fun searchTests(keyword: String?, page: Int, type: Int) {
        if (page == 1) {
            mView.showLoadingView()
        }
        ActionCountUtils.count(TEST_MAIN_SEARCH_CONTENT_CLICK,keyword.toString())
        val cmd = TestListCommand()
        cmd.tab = "search"
        cmd.page = page
        cmd.keyword = keyword
        cmd.type = type
        TestRetrofitApi.getTestRetrofitApi()
                .fetchTestList(NetworkParamsUtils.getMaps(cmd))
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    if (resp.code == 0) {
                        mView.hideLoadingView()
                        if (page == 1 && (resp.data.testList == null || resp.data.testList?.size == 0)) {
                            mView.showNoResultView()
                            mView.showSearchResultView(resp.data.testList, page)
                        } else {
                            mView.hideNoResultView()
                            mView.showSearchResultView(resp.data.testList, page)
                        }
                    } else {
                        mView.hideLoadingView()
                        ToastUtil.toastShort(resp.msg)
                    }
                }, { throwble ->
                    HttpErrorUtils.handleError(BaseApp.getApp(), throwble)
                })
    }
}