package com.yidianling.user

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.request.LoginParam
import io.reactivex.Observable

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/02
 */
interface LoginContract {

    interface View: IView {
        // 开始登录
        fun startLogin()
        // 登录成功
        fun loginSuccess(userInfo: UserResponseBean?)
        // 登录失败
        fun loginFail(msg: String)
        // 登录完成
        fun onLoginStop()

        fun showErrorUserType()
    }

    interface Model: IModel {
        fun login(param: LoginParam): Observable<BaseResponse<UserResponseBean>>
    }

    interface Presenter: IPresenter<View> {
        fun login(param: LoginParam)
    }

}