package com.yidianling.user.http

import android.app.Activity
import com.google.gson.internal.LinkedTreeMap
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.bean.CheckPhonePassBean
import com.yidianling.user.bean.CollectFocusItemBean
import com.yidianling.user.http.request.*
import com.yidianling.user.http.response.*
import com.yidianling.user.mine.bean.RedPacketId
import com.yidianling.user.mine.bean.RedPacketIdCmd
import io.reactivex.Observable
import java.io.File

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/02
 */
interface UserHttp {

    fun login(param: LoginParam): Observable<BaseResponse<UserResponseBean>>

    fun countryList(): Observable<BaseResponse<CountryResponse>>

    fun phoneExist(param: ExistParam): Observable<BaseResponse<ExistResponse>>

    fun code(param: CodeParam): Observable<BaseResponse<Any>>

    fun bindPhone(param: BindPhoneParam): Observable<BaseResponse<UserResponseBean>>

    fun forget(param: ForgetParam): Observable<BaseResponse<Any>>

    fun register(param: RegisterParam): Observable<BaseResponse<Any>>

    fun channelId(param: ChannelIdParam): Observable<BaseResponse<LinkedTreeMap<String, String>>>

    fun thirdPartLogin(param: ThirdLoginParam): Observable<BaseAPIResponse<UserResponseBean>>

    fun setUserInfo(param: UserInfoParam): Observable<BaseResponse<Any>>

    fun checkPhonePass(cmd: CheckPhonePassBean): Observable<BaseResponse<CheckPassword>>

    fun bindQQ(param: BindQQ): Observable<BaseResponse<Any>>

    fun bindWX(param: BindWX): Observable<BaseResponse<Any>>

    fun logout(param: Logout): Observable<BaseResponse<Any>>

    fun checkPwd(param: CheckPwd): Observable<BaseResponse<Any>>

    fun changePhone(param: ChangePhone): Observable<BaseResponse<Any>>

    fun privacyAgree(uid: String): Observable<BaseResponse<Any>>

    fun thirdPartJavaLogin(param: ThirdLoginParam): Observable<BaseResponse<UserResponseBean>>

    // 友盟第三方登录
    fun umLogin(activity: Activity, media: SHARE_MEDIA): Observable<ThirdLoginParam>

    fun unBindThirdLogin(param: UnBindThirdLoginParam): Observable<BaseResponse<Any>>

    fun getSecretJavaData(): Observable<BaseResponse<String>>

    fun getRedPacketId(param: RedPacketIdCmd): Observable<BaseResponse<RedPacketId>>

    fun userInfoCollectUpload(param: UserInfoCollectUploadParam): Observable<BaseAPIResponse<Any>>

    fun getFocusData(): Observable<BaseAPIResponse<List<CollectFocusItemBean>>>

    fun getNewUserJumpUrl(): Observable<BaseAPIResponse<String>>

    /**用户注销账号（禁止登录）*/
    fun userForbidLogin(param: UserForbidLoginParam):Observable<BaseAPIResponse<Boolean>>

    /**用户注销账号*/
    fun accountLogOff(param: UserForbidLoginParam):Observable<BaseAPIResponse<Boolean>>

    fun modifyUserBaseInfo(param: ModifyBaseInfo): Observable<BaseAPIResponse<Boolean>>

    fun getUserAuditInfo(type: BaseInfo): Observable<BaseAPIResponse<UserModifyAuditRespDto>>

    fun uploadFile(file: File): Observable<BaseAPIResponse<Boolean>>
}