package com.yidianling.user.http.response;

import com.ydl.ydlcommon.data.http.BaseResponse;
import com.yidianling.user.http.request.*;
import retrofit2.Call;
import retrofit2.http.*;

public interface AliAuthTokenApi {
    //    getVendorConfig
    @POST("phone/verification/init")
    Call<BaseResponse> getVendorConfig(@Header("ffrom") String ffrom, @Body InitPhoneRequest initPhoneRequest);

    @POST("user/login_direct")
//    Observable<BaseResponse> getLoginDirect(@Header("ffrom") String ffrom, @Body PhoneLoginDirectRequest phoneLoginDirectRequest);
    Call<BaseResponse> getLoginDirect(@Header("ffrom") String ffrom, @Body PhoneLoginDirectRequest phoneLoginDirectRequest);

    @POST("user/login_sms")
    Call<BaseResponse> loginBySMS(@Header("ffrom") String ffrom, @Body PhoneLoginSmsRequest PhoneLoginSmsRequest);

    //POST /user/login_pwd
    @POST("user/login_pwd")
    Call<BaseResponse> loginByPassword(@Header("ffrom") String ffrom, @Body PhoneLoginPwdRequest phoneLoginPwdRequest);

    //POST /user/reset_pwd
    @POST("user/reset_pwd")
    Call<BaseResponse> resetPwd(@Body ResetPwdRequest resetPwdRequest);

    @GET("user/phone_detection")
    Call<BaseResponse> getPhoneDetection(@Query("phone") String phone, @Query("countryCode") String countryCode);

    @GET("user/send_login_sms")
    Call<BaseResponse> sendLoginSms(@Query("phone") String phone, @Query("countryCode") String countryCode);

    @GET("user/send_reset_sms")
    Call<BaseResponse> sendResetSms(@Query("phone") String phone, @Query("countryCode") String countryCode);

    //验证重置密码的短信验证码
    @GET("user/precheck_reset_sms")
    Call<BaseResponse> precheckResetSms(@Query("phone") String phone, @Query("countryCode") String countryCode, @Query("code") String code);


    //验证重置密码的短信验证码
    @POST("user/bind_phone")
    Call<BaseResponse> bindPhone(@Header("ffrom") String ffrom, @Body BindPhoneRequest bindPhoneRequest);
}

//    fun bindQQ(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>
