package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.databinding.UserMineActivityAddAccountBinding
import com.yidianling.user.mine.bean.AddAccountCmd
import com.yidianling.user.mine.data.AppDataManager
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import kotlinx.android.synthetic.main.user_mine_activity_add_account.*

/**
 * @author liupeng
 * 添加提现账号
 * */
class AddAccountActivity : AppCompatActivity() {

    private lateinit var binding: UserMineActivityAddAccountBinding

    companion object {
        fun startForResult(activity: Activity, request: Int) {
            var intent = Intent(activity, AddAccountActivity::class.java)
            activity.startActivityForResult(intent, request)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.user_mine_activity_add_account)
        btn_ensure.setOnClickListener {
            saveAccount()
        }
    }

    /**
     * 保存支付宝帐号
     */
    @SuppressLint("CheckResult")
    private fun saveAccount() {
        var account = et_account.text.trim().toString()
        if (TextUtils.isEmpty(account)) {
            ToastUtil.toastShort("支付宝帐号不能为空")
            return
        }
        var name = et_name.text.trim().toString()
        if (TextUtils.isEmpty(name)) {
            ToastUtil.toastShort("姓名不能为空")
            return
        }

        var param = AddAccountCmd(name, account, "1")
        AppDataManager.getHttp().addAccount(param)
            .compose(RxUtils.resultData())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe(Consumer {bean ->
                if (bean == null) {
                    ToastUtil.toastShort("返回数据错误")
                } else {
                    ToastUtil.toastShort("添加帐号成功")
                    var intent = Intent()
                    intent.putExtra(ChooseAccountActivity.ADD_ACCOUNT_REQUEST_KEY, bean)
                    setResult(Activity.RESULT_OK, intent)
                    finish()
                }
            }, object : ThrowableConsumer() {
                override fun accept(msg: String) {
                    ToastUtil.toastShort(msg)
                }
            })
    }
}