package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.content.Intent
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.hardware.Camera
import android.net.Uri
import android.os.Build
import android.provider.MediaStore
import android.text.Spannable
import android.text.SpannableString
import android.text.style.ForegroundColorSpan
import android.widget.ImageView
import android.widget.TextView
import com.alibaba.android.arouter.launcher.ARouter
import com.bumptech.glide.Glide
import com.hjq.permissions.OnPermissionCallback
import com.hjq.permissions.Permission
import com.hjq.permissions.XXPermissions
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.modular.findRouteService
import com.ydl.ydlcommon.utils.FileUtils
import com.ydl.ydlcommon.utils.extend.visible
import com.ydl.ydlcommon.view.TitleBar
import com.yidianling.common.tools.ToastUtil
import com.yidianling.im.api.service.IImService
import com.yidianling.user.R
import com.yidianling.user.api.service.IUserService
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.http.request.BaseInfo
import com.yidianling.user.http.request.UserModifyAuditRespDto
import de.greenrobot.event.EventBus
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import java.io.File
import java.io.IOException


class ModifyAvatarActivity : BaseActivity() {

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = false).apply {
            statusColor = "#E6000000"
        }
    }

    private val ALBUM = 0x0 // 相册
    private val CAMERA = 0x1 // 照相
    private val CROP = 0x2 // 裁剪m

    private val mAvatarDir = "${FileUtils.getStorageDirectory()}/img/head_img/" // 头像目录
    private val mAvatarPath = "${mAvatarDir}avatar_camera.jpg" // 头像
    private val mAvatarFile = File(mAvatarPath) // 头像文件
    private val mUserInfo = findRouteService(IUserService::class.java).getUserInfo()

    override fun layoutResId(): Int = R.layout.activity_modify_avatar

    private lateinit var tip_bar: TitleBar
    private lateinit var tv_tip1: TextView
    private lateinit var iv_avatar: ImageView
    private lateinit var iv_warn: ImageView
    private lateinit var tv_tip2: TextView
    private lateinit var tv_modify: TextView

    private fun findView() {
        tip_bar = findViewById(R.id.tip_bar)
        tv_tip1 = findViewById(R.id.tv_tip1)
        iv_avatar = findViewById(R.id.iv_avatar)
        iv_warn = findViewById(R.id.iv_warn)
        tv_tip2 = findViewById(R.id.tv_tip2)
        tv_modify = findViewById(R.id.tv_modify)
    }

    @SuppressLint("SetTextI18n")
    override fun initDataAndEvent() {
        findView()
        tip_bar.setOnLeftTextClick { _, _ ->
            setResult(RESULT_OK) // 刷新个人资料页
            finish()
        }
        mUserInfo ?: return
        mDisposables.add(
            UserHttpImpl.getInstance()
                .getUserAuditInfo(BaseInfo(102))
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe { response: BaseAPIResponse<UserModifyAuditRespDto> ->
                    if (response.code != "200") return@subscribe
                    val (auditReason, auditStatus, _, _, _, _, _, last7Day, modifyAfter) = response.data
                    when (auditStatus) {
                        1 -> { // 审核中
                            underReview()
                            Glide.with(this)
                                .load(modifyAfter)
                                .into(iv_avatar)
                        }
                        2 -> { // 审核失败
                            tv_tip1.text = "七天内可修改一次头像"
                            Glide.with(this)
                                .load(mUserInfo.head)
                                .into(iv_avatar)
                            iv_warn.visible()
                            tv_tip2.text =
                                SpannableString("审核失败，$auditReason。如有疑问联系客服小壹").also {
                                    it.setSpan(
                                        ForegroundColorSpan(resources.getColor(R.color.color_1DA1F2)),
                                        it.lastIndexOf("客服"),
                                        it.length,
                                        Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
                                    )
                                }
                            tv_tip2.setOnClickListener { // 客服
                                ARouter.getInstance().navigation(
                                    IImService::class.java
                                ).startKefuChat(this, "", 0, 0)
                            }
                            setModifyAvatar()
                        }
                        3 -> { // 审核成功 || 提交审核
                            modifyAfter?.let {
                                mUserInfo.head = it
                                Glide.with(this)
                                    .load(it)
                                    .error(R.drawable.platform_head_place_hold_pic)
                                    .into(iv_avatar)
                            }
                            findRouteService(IImService::class.java).updateUserHead(modifyAfter) // 更新用户头像到云信
                            EventBus.getDefault().post(UserChangeEvent(true)) // 更新MineFragment
                            if (last7Day) {
                                tv_tip1.text = "抱歉，七天内只能修改一次头像"
                                tv_modify.isEnabled = false
                                tv_modify.setBackgroundResource(R.drawable.bg_c3c4ca_corner_8)
                            } else {
                                tv_tip1.text = "七天内可修改一次头像"
                                setModifyAvatar()
                            }
                        }
                    }
                })
    }

    private fun setModifyAvatar() {
        tv_modify.setOnClickListener {
            requestPermissions {
                optionDialog()
            }
        }
    }

    private fun requestPermissions(block: () -> Unit) {
        if (XXPermissions.isGrantedPermission(this, Permission.CAMERA)) {
            block.invoke()
        } else {
            XXPermissions.with(this)
                .permission(Permission.CAMERA)
                .request(object : OnPermissionCallback {
                    override fun onGranted(permissions: MutableList<String>?, all: Boolean) {
                        block.invoke()
                    }

                    override fun onDenied(permissions: MutableList<String>?, never: Boolean) {
                        ToastUtil.toastLong(this@ModifyAvatarActivity, "缺少使用相机和读取存储权限，无法获取图片")
                    }
                })
        }
    }

    private fun optionDialog() {
        showFragment(AvaterDialog().apply {
            listener = { position, dialog ->
                val file = File(mAvatarDir)
                if (!file.exists()) file.mkdirs()
                when (position) {
                    0 -> { // 相册
                        val intent = Intent(Intent.ACTION_PICK, null)
                        intent.setDataAndType(
                            MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                            "image/*"
                        )
                        this@ModifyAvatarActivity.startActivityForResult(intent, ALBUM)
                    }
                    1 -> { // 拍照
                        callCamera()
                    }
                }
                dialog.dismiss()
            }
        }, "avater")
    }

    /**
     * 调用相机
     */
    private fun callCamera() {
        val intent = Intent()
        packageManager.getLaunchIntentForPackage("com.android.camera")?.run {
            intent.setPackage("com.android.camera")
        }
        intent.action = MediaStore.ACTION_IMAGE_CAPTURE
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) { // api 24
            intent.putExtra(
                "android.intent.extras.CAMERA_FACING",
                Camera.CameraInfo.CAMERA_FACING_FRONT
            ) // 调用前置摄像头
            intent.putExtra("autofocus", true) // 自动对焦
            intent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(mAvatarFile))
            intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString())
            startActivityForResult(intent, CAMERA)
        } else {
            try {
                mAvatarFile.createNewFile()
            } catch (e: IOException) {
                e.printStackTrace()
            }
            val uri: Uri = FileUtils.getImageContentUri(this, mAvatarFile)
            intent.putExtra(
                "android.intent.extras.CAMERA_FACING",
                Camera.CameraInfo.CAMERA_FACING_FRONT
            ) // 调用前置摄像头
            intent.putExtra("autofocus", true) // 自动对焦
            intent.putExtra(MediaStore.EXTRA_OUTPUT, uri)
            intent.putExtra("outputFormat", Bitmap.CompressFormat.JPEG.toString())
            startActivityForResult(intent, CAMERA)
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == RESULT_OK) {
            when (requestCode) {
                ALBUM -> { // 相册
                    data?.let {
                        startPhotoZoom(it.data)
                    }
                }
                CAMERA -> { // 拍照
                    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N) { // api 24
                        if (mAvatarFile.exists()) {
                            startPhotoZoom(Uri.fromFile(mAvatarFile))
                        }
                    } else {
                        startPhotoZoom(FileUtils.getImageContentUri(this, mAvatarFile))
                    }
                }
                CROP -> {
                    mUserInfo ?: return
                    showProgressDialog("保存中...")
                    val path = FileUtils.getPathByUri4kitkat(this, Uri.fromFile(mAvatarFile))
                    var bitmap = BitmapFactory.decodeFile(path)
                    bitmap = FileUtils.getZoomImage(bitmap, 200.0)
                    val outPutFile = FileUtils.saveBitmap(bitmap, path)
                    mDisposables.add(
                        UserHttpImpl.getInstance().uploadFile(outPutFile)
                            .subscribeOn(Schedulers.io())
                            .observeOn(AndroidSchedulers.mainThread())
                            .subscribe {
                                dismissProgressDialog()
                                if (it.code != "200") {
                                    ToastUtil.toastShort(it.msg)
                                    return@subscribe
                                }
                                ToastUtil.toastShort("头像审核中，预计24小时内审核完成")
                                underReview()
                                iv_avatar.setImageBitmap(bitmap)
                            }
                    )
                }
            }
        }
    }

    /**
     * 审核中
     */
    @SuppressLint("SetTextI18n")
    private fun underReview() {
        tv_tip1.text = "抱歉，七天内只能修改一次头像"
        tv_tip2.text = "审核中，预计24小时内审核完成，暂无法修改。"
        tv_modify.setBackgroundResource(R.drawable.bg_c3c4ca_corner_8)
        tv_modify.isEnabled = false
    }

    /**
     * 裁剪图片方法实现
     */
    private fun startPhotoZoom(uri: Uri?) {
        val intent = Intent("com.android.camera.action.CROP").apply {
            setDataAndType(uri, "image/*")
            putExtra("crop", "true") // 设置裁剪
            putExtra("scaleUpIfNeeded", true) // 图片拉伸，就不会出现黑框了
            //宽高的比例
            putExtra("aspectX", 1)
            putExtra("aspectY", 1)
            //裁剪图片宽高
            putExtra("outputX", 200)
            putExtra("outputY", 200)
        }
        intent.putExtra(MediaStore.EXTRA_OUTPUT, Uri.fromFile(mAvatarFile))
        intent.putExtra("outputFormat", Bitmap.CompressFormat.PNG.toString())
//         return-data=true传递的为缩略图，小米手机默认传递大图，所以会导致onActivityResult调用失败
        intent.putExtra("return-data", false)
//        intent.putExtra("noFaceDetection", false) // 是否需要人脸识别
        startActivityForResult(intent, CROP)
    }
}