package com.yidianling.user.mine;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import com.ydl.ydlcommon.view.RoundCornerButton;
import com.yidianling.user.R;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by Emma on 2016/8/5.
 */
public class RechargeGridView extends LinearLayout {
    List<RoundCornerButton> mList = new ArrayList<>();


    RoundCornerButton rcb_01;
    RoundCornerButton rcb_02;
    RoundCornerButton rcb_03;
    RoundCornerButton rcb_04;
    RoundCornerButton rcb_05;
    RoundCornerButton rcb_06;

    private ItemClickListener itemClickListener;

    private void initView() {
        rcb_01 = findViewById(R.id.rcb_01);
        rcb_02 = findViewById(R.id.rcb_02);
        rcb_03 = findViewById(R.id.rcb_03);
        rcb_04 = findViewById(R.id.rcb_04);
        rcb_05 = findViewById(R.id.rcb_05);
        rcb_06 = findViewById(R.id.rcb_06);
    }

    public RechargeGridView(Context context) {
        super(context);
        inflate(context, R.layout.user_mine_ui_recharge_gv, this);
        initView();
        init();
    }

    public RechargeGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        inflate(context, R.layout.user_mine_ui_recharge_gv, this);
        initView();
        init();
    }

    public RechargeGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        inflate(context, R.layout.user_mine_ui_recharge_gv, this);
        initView();
        init();
    }

    void init() {
        mList.clear();
        mList.add(rcb_01);
        mList.add(rcb_02);
        mList.add(rcb_03);
        mList.add(rcb_04);
        mList.add(rcb_05);
        mList.add(rcb_06);
        for (int i = 0; i < mList.size(); i++) {
            mList.get(i).setStroke(0, 0x00000000);
        }
        setListener();
    }

    public void setFirstBg(int c) {
        rcb_01.setBg(c);
    }


    public void setListener() {
        for (int i = 0; i < mList.size(); i++) {
            final int finalI = i;
            mList.get(i).setOnClickListener(view -> {
                if (itemClickListener != null)
                    itemClickListener.clickItem(view, finalI);
            });
        }
    }

    public void setItemClickListener(ItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public interface ItemClickListener {
        void clickItem(View view, int position);
    }

    public void setTexts(List<String> names) {
        for (int i = 0; i < mList.size(); i++) {
            mList.get(i).setText(names.get(i));
        }
    }

    public List<RoundCornerButton> getChildList() {
        return mList;
    }

}
