package com.yidianling.user.mine.data

import android.content.Context
import android.content.SharedPreferences
import com.ydl.ydlcommon.base.BaseApp

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/27
 */
internal class AppLocalImpl private constructor(): AppLocal {

    companion object {
        fun getInstance(): AppLocalImpl {
            return Holder.INSTANCE
        }

        private const val APP = "app"
        private const val RED_POCKET_TIME = "red_pocket_time"
        private const val UPDATE = "update"

        private const val CONFIDE = "confide"
        private const val CONSULT = "consult"
        private const val CONSULT_NUM = "consult_num"
        private const val COUPON = "coupon"
    }


    override fun getRedPocketTime(): Long {
        return getAppSP().getLong(RED_POCKET_TIME, 0)
    }

    override fun putRedPocketTime(time: Long) {
        getAppSP().edit().putLong(RED_POCKET_TIME, time).apply()
    }

    override fun hasUpdate(): Boolean {
        return getAppSP().getBoolean(UPDATE, false)
    }

    override fun putUpdate(update: Boolean) {
        getAppSP().edit().putBoolean(UPDATE, update).apply()
    }

    override fun getCoupon(): Boolean {
        return getAppSP().getBoolean(COUPON, false)
    }

    override fun setCoupon(have: Boolean) {
        getAppSP().edit().putBoolean(COUPON, have).apply()
    }

    override fun getConsult(): Boolean {
        return getAppSP().getBoolean(CONSULT, false)
    }

    override fun setConsult(have: Boolean) {
        getAppSP().edit().putBoolean(CONSULT, have).apply()
    }

    override fun getConsultNum(): Int {
        return getAppSP().getInt(CONSULT_NUM, 0)
    }

    override fun setConsultNum(num: Int) {
        getAppSP().edit().putInt(CONSULT_NUM, num).apply()
    }

    override fun getConfide(): Boolean {
        return getAppSP().getBoolean(CONFIDE, false)
    }

    override fun setConfide(have: Boolean) {
        getAppSP().edit().putBoolean(CONFIDE, have).apply()
    }

    private fun getAppSP(): SharedPreferences {
        return BaseApp.getApp().getSharedPreferences(APP, Context.MODE_PRIVATE)
    }



    private object Holder {
        internal val INSTANCE = AppLocalImpl()
    }

}