package com.yidianling.user.mine.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.yidianling.user.R;

import in.srain.cube.views.loadmore.LoadMoreContainer;
import in.srain.cube.views.loadmore.LoadMoreUIHandler;

/**
 * Created by softrice on 15/12/25.
 */
public class LoadMoreFooterView extends RelativeLayout implements LoadMoreUIHandler {
    TextView tv_content;
    ProgressBar circle_progress;

    int loadingcolor;
    int finishColor;
    int emptyColor;

    String loadingText = "正在加载...";
    String finishText = "没有更多了";
    String emptyText;

    public void setEmptyColor(int emptyColor) {
        this.emptyColor = emptyColor;
    }

    public void setEmptyText(String emptyText) {
        this.emptyText = emptyText;
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public void setFinishText(String finishText) {
        this.finishText = finishText;
    }

    public void setLoadingcolor(int loadingcolor) {
        this.loadingcolor = loadingcolor;
    }

    public void setFinishColor(int finishColor) {
        this.finishColor = finishColor;
    }

    public LoadMoreFooterView(Context context) {
        super(context);
//        inflate(context,R.layout.ui_load_more_footer,this);

        setupViews();
    }

    private void setupViews() {
        LayoutInflater.from(getContext()).inflate(R.layout.user_mine_ui_load_more_footer, this);
        tv_content = (TextView) findViewById(R.id.tv_content);
        circle_progress = (ProgressBar) findViewById(R.id.circle_progress);
        loadingcolor = getContext().getResources().getColor(R.color.platform_color_grey_555555);
        finishColor = getContext().getResources().getColor(R.color.platform_color_333333);
        emptyColor = getContext().getResources().getColor(R.color.platform_color_333333);

        setVisibility(INVISIBLE);
    }

    @Override
    public void onLoading(LoadMoreContainer container) {
//        circle_progress.setVisibility(VISIBLE);
        setVisibility(VISIBLE);
        tv_content.setText(loadingText);
        tv_content.setTextColor(loadingcolor);
    }

    @Override
    public void onLoadFinish(LoadMoreContainer container, boolean empty, boolean hasMore) {
//        circle_progress.setVisibility(GONE);
//        tv_content.setTextColor(finishColor);
        if (!hasMore) {
            setVisibility(VISIBLE);
            if (empty) {
                tv_content.setTextColor(emptyColor);
                tv_content.setText(emptyText);
            } else {
                tv_content.setTextColor(finishColor);
                tv_content.setText(finishText);
                circle_progress.setVisibility(INVISIBLE);
            }
        } else {
//            tv_content.setText("");
            circle_progress.setVisibility(VISIBLE);
            setVisibility(INVISIBLE);
        }
    }

    @Override
    public void onWaitToLoadMore(LoadMoreContainer container) {
//        circle_progress.setVisibility(GONE);
        setVisibility(VISIBLE);
        tv_content.setText("");
    }
}
