package com.yidianling.user.ui.collect.widget

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Color
import android.graphics.Typeface
import androidx.core.content.ContextCompat
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.widget.LinearLayout
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool
import com.yidianling.user.R
import kotlinx.android.synthetic.main.user_item_focus_layout.view.*


class CollectFocusView : LinearLayout {


    constructor(context: Context) : super(context) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {

        View.inflate(mContext, R.layout.user_item_focus_layout, this)
        val mWidth: Int = RxDeviceTool.getScreenWidth(mContext) / 2 - RxImageTool.dp2px(20f + 9.5f)

        val params = LinearLayout.LayoutParams(
            mWidth,
            RxImageTool.dp2px(68f)
        )
        layoutParams = params

        setFocus(false)

    }

    @SuppressLint("ResourceAsColor")
    fun setFocus(focus: Boolean) {
        if (focus) {
            user_focus_title.setTextColor(ContextCompat.getColor(mContext!!, R.color.platform_main_theme))
            user_focus_desc.setTextColor(ContextCompat.getColor(mContext!!, R.color.platform_main_theme))
            user_focus_title.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
            setBackgroundResource(R.drawable.user_collect_select_bg)
        } else {
            user_focus_title.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
            user_focus_title.setTextColor(Color.parseColor("#242424"))
            user_focus_desc.setTextColor(Color.parseColor("#666666"))
            setBackgroundResource(R.drawable.user_collect_unselect_bg)
        }
    }

    fun setData(title: String, desc: String) {
        user_focus_title.text = title
        user_focus_desc.text = desc
    }
}