package com.yidianling.user.ui.login.contract

import android.app.Activity
import com.mobile.auth.gatewayauth.model.VendorConfig
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.request.BindPhoneJavaParam
import com.yidianling.user.http.request.CheckAliAuthParam
import com.yidianling.user.http.request.PhoneLoginAutoParam
import com.yidianling.user.http.request.ThirdLoginParam
import com.yidianling.user.http.response.ChcekPhoneResponeBean
import com.yidianling.user.http.response.PhoneAuthResponseBean
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:新版登录注册约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/28
 */
interface ILoginContract {

    interface View : IView {
        /**
         * 菊花条
         */
        fun showLoading(state: Boolean)

        /**
         * 显示进度条
         */
        fun showProgressView()

        /**
         * 关闭进度条
         */
        fun dismissProgressView()

        /**
         * 三方登录成功
         */
        fun thirdLoginSuccess(userInfo: UserResponseBean.UserInfo,thirdLoginPlatform:String)

        /**
         * 弹窗
         */
        fun showNormalDialog()

        /**
         * 已经绑定过弹窗
         */
        fun showHasBindedDialog()

        /**
         * 校验手机号(是否是用户版号码、是否有设置密码、是否被绑定)成功
         */
        fun checkPhoneStatusSuccess(bean: ChcekPhoneResponeBean?, phone: String)

        /**
         * 服务端阿里认证失败
         */
        fun aliAuthFailed()

        /**
         * 手机号绑定成功
         */
        fun bindSuccess()

        /**
         * sdk
         *自动登录成功
         */
        fun autoLoginSuccess()

        /**
         * 三方登录成功后如果判断是第一次登录，则未注册，进行百度埋点
         */
        fun baiduActionBury(uid: String? = "", type: String)
    }

    interface Presenter : IPresenter< View> {
        /**
         * 三方登录
         */
        fun loginByThird(activity: Activity, media: SHARE_MEDIA)

        /**
         * 服务端校验阿里一键认证
         */
        fun checkAliAuth(param: CheckAliAuthParam)

        /**
         * 校验手机号：是否是用户版号码、是否有设置密码、是否被绑定
         */
        fun checkPhoneStatus(phone: String, countryCode: String, isBind: Boolean)

        /**
         * 通过一键认证服务登陆
         */
        fun autoLogin(bean: PhoneLoginAutoParam)

        /**
         *
        绑定手机号
         */
        fun bindPhone(param: BindPhoneJavaParam)
    }

    interface Model : IModel {
        /**
         * 三方登录
         */
        fun loginByThird(activity: Activity, media: SHARE_MEDIA): Observable<ThirdLoginParam>

        /**
         * 校验手机号：是否是用户版号码、是否有设置密码、是否被绑定
         */
        fun checkPhoneStatus(phone: String, countryCode: String): Observable<BaseResponse<ChcekPhoneResponeBean>>


        /**
         * 服务端校验阿里一键认证
         */
        fun checkAliAuth(param: CheckAliAuthParam): Observable<BaseResponse<PhoneAuthResponseBean>>

        /**
         * 通过一键认证服务登陆
         */
        fun autoLogin(bean: PhoneLoginAutoParam): Observable<BaseResponse<UserResponseBean>>

        /**
         *
        绑定手机号
         */
        fun bindPhone(param: BindPhoneJavaParam): Observable<BaseResponse<Any>>
    }
}
