package com.yidianling.user.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.text.Spannable
import android.text.SpannableString
import android.text.TextPaint
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import androidx.core.content.ContextCompat
import com.yidianling.user.R
import com.yidianling.user.ui.login.H5Activity
import kotlinx.android.synthetic.main.user_agree_privacy_dialog.*

class AgreePrivacyBottomDialog(context: Context, private val listener: OnAgreeBottomListener?) :
    Dialog(context, R.style.platform_dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.user_agree_privacy_dialog)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.BOTTOM)
        window.attributes = params

        user_dialog_no_agree.setOnClickListener {
            //拒绝
            listener?.onCancel()
            dismiss()
        }

        user_dialog_secret_agree.setOnClickListener {
            //同意
            listener?.onSure()
            dismiss()
        }
        user_agree_dialog_protocol.text = agreeDialogProtocol()
        user_agree_dialog_protocol.movementMethod = LinkMovementMethod.getInstance()
    }

    interface OnAgreeBottomListener {
        fun onCancel()
        fun onSure()
    }

    private fun agreeDialogProtocol(): SpannableString {
        val name = "请先同意" + context.resources.getString(R.string.user_login_name_start)
        val str = "${name}用户使用协议、隐私\n保护政策才能登录使用哦"
        var start = name.length
        val spannableString = SpannableString(str)
        spannableString.setSpan(object : ClickableSpan() {
            override fun updateDrawState(ds: TextPaint) {
                super.updateDrawState(ds)
                ds.color =
                    ContextCompat.getColor(context, R.color.user_1da1f2trans)
                ds.isUnderlineText = true      //设置下划线
            }

            override fun onClick(widget: View) {
                H5Activity.start(context, false)
            }
        }, start, start + 6, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        spannableString.setSpan(object : ClickableSpan() {
            override fun updateDrawState(ds: TextPaint) {
                super.updateDrawState(ds)
                ds.color =
                    ContextCompat.getColor(context, R.color.user_1da1f2trans)
                ds.isUnderlineText = true      //设置下划线
            }

            override fun onClick(widget: View) {
                H5Activity.start(context, true)
            }
        }, start + 7, start + 13, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        return spannableString
    }
}