package com.yidianling.user.widget

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.os.Bundle
import android.text.Html
import android.text.SpannableString
import android.text.Spanned
import android.text.TextPaint
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.ydl.ydlcommon.utils.Utils
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.user.R
import com.yidianling.user.constants.UserBIConstants
import com.yidianling.user.ui.login.H5Activity
import kotlinx.android.synthetic.main.user_dialog_secret.*


class SecretDescriptionDialog(
    var mContext: Context,
    var mSecretProtocolString: String,
    private val listener: OnSecretDescriptionDialogListener?
) : Dialog(mContext, R.style.platform_dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.user_dialog_secret)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.CENTER)
        window.attributes = params

        user_secret_desc.text = Html.fromHtml(mSecretProtocolString)

        user_secret_no_agree.setOnClickListener {
            ActionCountUtils.count(
                UserBIConstants.PRIVACY_AUTHORIZATION_TWO_CLICK,
                "拒绝"
            )
            listener?.onCancel()
        }

        user_secret_agree.setOnClickListener {
            ActionCountUtils.count(UserBIConstants.PRIVACY_AUTHORIZATION_CLICK, "同意")
            agreeAction()
        }

        val str = "阅读完整版《用户使用协议》、《隐私保护政策》"
        val spannableString = SpannableString(str)
//        spannableString.setSpan(
//            ForegroundColorSpan(Color.parseColor("#159CEF")),
//            5,
//            13,
//            Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
//        )
//        spannableString.setSpan(
//            ForegroundColorSpan(Color.parseColor("#159CEF")),
//            str.length - 8,
//            str.length,
//            Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
//        )
        spannableString.setSpan(
            object : ClickableSpan() {
                override fun onClick(widget: View?) {
                    if (Utils.isFastClick()) {
                        return
                    }
                    H5Activity.start(mContext, false)
                }

                override fun updateDrawState(ds: TextPaint?) {
                    ds?.color = Color.parseColor("#159CEF")
                }
            }, 5,
            13, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        spannableString.setSpan(
            object : ClickableSpan() {
                override fun onClick(widget: View?) {
                    if (Utils.isFastClick()) {
                        return
                    }
                    H5Activity.start(mContext, true)
                }

                override fun updateDrawState(ds: TextPaint?) {
                    ds?.color = Color.parseColor("#159CEF")
                }
            }, str.length - 8,
            str.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        tv_content.movementMethod = LinkMovementMethod.getInstance()
        tv_content.highlightColor = Color.TRANSPARENT
        tv_content.text = spannableString
    }

    private fun agreeAction() {
        SharedPreferencesEditor.putString("hasAgreeSecret", "true")
        listener?.onSure()
    }

    interface OnSecretDescriptionDialogListener {
        fun onCancel()
        fun onSure()
    }


}