package com.yidianling.user.widget

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.WindowManager
import com.ydl.ydlcommon.utils.SharedPreferencesEditor
import com.yidianling.user.R
import kotlinx.android.synthetic.main.user_secret_dialog_layout.*

class SecretDialog(context: Context, private val listener: OnSecretDialogListener?) :
    Dialog(context, R.style.platform_dialog_default_style) {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.user_secret_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.CENTER)
        window.attributes = params

        user_secret_dialog_agree.setOnClickListener {
            agreeAction()
        }

        user_secret_dialog_no_agree.setOnClickListener {
            listener?.onCancel()
        }
    }

    interface OnSecretDialogListener {
        fun onCancel()
        fun onSure()
    }

    private fun agreeAction() {
        SharedPreferencesEditor.putString("hasAgreeSecret", "true")
        listener?.onSure()
    }

}