package com.ydl.media.audio


import com.ydl.media.audio.model.Music

/**
 * Created by haorui on 2019-10-27 .
 * Des:播放进度监听器
 *
 * todo: [onStartPlay]和[onPrepared]调用顺序有问题,不改是因为多处调用
 */
interface OnPlayerEventListener {

    /**
     * 加载之前
     * @return true: 可加载
     */
    fun onPreLoad(playPosition: Int): Boolean = true

    /**
     * 加载之后
     */
    fun onLoad(music: Music)

    /**
     * 开始播放
     *
     */
    fun onStartPlay()

    /**
     * 准备完成
     *
     * duration:音乐时长
     */
    fun onPrepared(duration:Long)

    /**
     * 缓冲百分比
     */
    fun onBufferingUpdate(percent: Int)

    /**
     * 更新进度
     * percent : 播放百分比
     * currentPosition：当前播放位置
     */
    fun onPublish(percent: Int,currentPosition: Long)

    /**
     * 播放完成
     */
    fun onComplete()

    /**
     * 暂停播放
     */
    fun onPausePlay()
}
