package com.ydl.media.view

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.media.audio.AudioPlayer

/**
 * 音频播放悬浮窗 帮助类
 *
 * 需要在Activity onDestroy中调用removeView()方法移除
 * 避免内存泄露
 */
class PlayerFloatHelper {

    companion object {
        private var mPlayerFloatView: PlayerFloatView? = null
        var isCanClick = true

        var playingType = PlayTypeEnum.PLAY_TYPE_NONE
        var playTempData = hashMapOf<String,String>()
        /**
         * 如果有音频正在播放则显示
         */
        fun showIfPlaying(context: Context) {
            if (AudioPlayer.get().isPlaying) {
                show(context)
            } else {
                removeView()
            }
        }

        /**
         * 显示悬浮控件
         */
        fun show(context: Context, playTypeEnum: PlayTypeEnum = PlayTypeEnum.PLAY_TYPE_NONE, playData:HashMap<String,String> = hashMapOf()) {
            if (playData.size > 0) {
                this.playTempData.putAll(playData)
            }

            if (mPlayerFloatView == null) {
                playingType = playTypeEnum
                mPlayerFloatView = PlayerFloatView(context).show()
            }
            mPlayerFloatView?.updatePlayState()
        }

        fun addClickListener(listener: PlayerFloatView.FloatViewPlayListener) {
            mPlayerFloatView?.addFloatClickListener(listener)
        }

        fun removeClickListener(listener: PlayerFloatView.FloatViewPlayListener) {
            mPlayerFloatView?.removeFloatClickListener(listener)
        }

        fun isShow(): Boolean {
            return null != mPlayerFloatView
        }

        /**
         * 只移除悬浮窗
         */
        fun removeView() {
            playTempData.clear()
            mPlayerFloatView?.let {
                it.remove()
                it.removeAllViews()
            }
            mPlayerFloatView = null
        }

        /**
         * 移除悬浮窗 + 重置音频播放器
         */
        fun removeResetView() {
            playTempData.clear()
            mPlayerFloatView?.let {
                it.removeAndReset()
                it.removeAllViews()
            }
            mPlayerFloatView = null
        }

        fun setPlayingState(context: Context) {
            show(context)
            mPlayerFloatView?.setPlayingState()
        }

        fun updatePlayState() {
            mPlayerFloatView?.updatePlayState()
        }

        /**
         * 打开播放中的页面详情
         */
        fun startPlayingActivity(context: Context?, fullScreen: Int = 0) {
            if (playingType == PlayTypeEnum.PLAY_TYPE_FM) {
                //FM播放页
                startFMPlayActivity()
            } else if (playingType == PlayTypeEnum.PLAY_TYPE_COURSE) {
                val url = AudioPlayer.get().playMusic?.path
                //课程播放页
                startCoursePlayActivity(context, 1, fullScreen, url, true)
            }
        }

        fun startCoursePlayActivity(context: Context?, from: Int, fullScreen: Int = 0, coursePlayUrl: String? = "", isFromFloatView: Boolean = false) {
            val courseId = playTempData["course_id"]?.toInt() ?: 0
            if ("1" == playTempData["media_type"]) { // 音频
                ARouter.getInstance()
                    .build("/course/audioPlay")
                    .withInt("course_id", courseId)
                    .withString("coursePlayUrl", coursePlayUrl)
                    .withInt("from", from)
                    .withBoolean("isFromFloatView", isFromFloatView)
                    .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    .navigation()
            } else {
                ARouter.getInstance()
                    .build("/course/play")
                    .withInt("course_id", courseId)
                    .withInt("course_type", 0)
                    .withString("coursePlayUrl", coursePlayUrl)
                    .withInt("from", from)
                    .withBoolean("isFromFloatView", isFromFloatView)
                    .withInt("fullScreen", fullScreen)
                    .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    .navigation()
            }
        }

        private fun startFMPlayActivity() {
            val bundle = Bundle()
            bundle.putInt("id", playTempData["fmId"]?.toInt()?:0)
            ARouter.getInstance().build("/fm/detail")
                .withBundle("bundle", bundle)
                .navigation()
        }

        /**
         * 获取FM播放Id
         */
        fun getFmId(): Int {
            return playTempData["fmId"]?.toInt()?:0
        }

    }

}
