package com.ydl.ydlnet.client.download;


import com.ydl.ydlnet.builder.factory.ApiFactory;
import com.ydl.ydlnet.builder.interceptor.YDLTransformer;
import io.reactivex.Observable;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;

/**
 * Created by haorui on 2019-09-02 .
 * Des: 下载单独 retrofit
 */
public class DownloadHelper {
    public static Observable<ResponseBody> downloadFile(String fileUrl) {

        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor(new DownloadInterceptor()).build();

        return ApiFactory.getInstance()
                .createApi(DownloadApi.class,okHttpClient)
                .downloadFile(fileUrl)
                .compose(YDLTransformer.<ResponseBody>switchSchedulers());
    }
}
