package com.ydl.ydlcommon.actions.share

import android.app.Activity
import android.graphics.Bitmap
import android.text.TextUtils
import com.umeng.socialize.ShareAction
import com.umeng.socialize.UMShareListener
import com.umeng.socialize.bean.SHARE_MEDIA
import com.umeng.socialize.media.UMImage
import com.umeng.socialize.media.UMMin
import com.umeng.socialize.media.UMWeb
import com.umeng.socialize.shareboard.ShareBoardConfig
import com.ydl.ydlcommon.utils.remind.ToastHelper
import com.ydl.ydlcommon.view.dialog.CustomShareDialog
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.ToastUtil
/**
 * 分享工具类
 */

object ShareUtils {

    var platform: SHARE_MEDIA? = null

    var callBack: ShareActionCallBack? = null

    /**
     * 直接分享到指定平台
     * @param platform
     */
    fun shareTo(platform: SHARE_MEDIA?, context: Activity, share_title: String, share_url: String, share_context: String?, share_head: String?) {
        LogUtil.d("shareTo")
        val web = UMWeb(share_url)
        web.title = share_title //标题
        if (platform == SHARE_MEDIA.WEIXIN_CIRCLE) {
            web.title = "$share_title\n$share_context"
        }
        web.setThumb(UMImage(context, share_head
                ?: "http://static.ydlcdn.com/v1/images/logo320.png"))  //缩略图
        web.description = share_context//描述
        ShareAction(context)
                .setPlatform(platform)
                .setCallback(object : UMShareListener {
                    override fun onStart(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "开始分享------")
                    }

                    override fun onResult(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "分享结束------")
                        callBack?.onShareSuccessed(share_media)
                        callBack = null
                    }

                    override fun onError(share_media: SHARE_MEDIA, throwable: Throwable) {
                        LogUtil.e("ydl", "分享出错------" + throwable.message)
                        try {
                            var message = handleMessage(throwable.message!!)
                            ToastUtil.toastShort("分享失败," + message)
                        } catch (e: Exception) {
                            ToastUtil.toastShort("分享错误")
                        }
                        callBack?.onShareFailed(share_media, throwable)
                        callBack = null
                    }

                    override fun onCancel(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "分享取消------")
                    }
                })
                .withMedia(web)
                .share()
    }

    /**
     * 分享纯图片到微信
     */
    fun sharePicToWeiXin(context: Activity, bitmap: Bitmap?) {
        if (bitmap == null) {
            ToastUtil.toastShort("数据异常，请重试")
            return
        }
        if (platform == null) {
            ToastUtil.toastShort("分享异常，请重试")
            return
        }
        val image = UMImage(context, bitmap)//bitmap文件

        val thumb = UMImage(context, bitmap)
        image.setThumb(thumb)

        image.compressStyle = UMImage.CompressStyle.SCALE//大小压缩，默认为大小压缩，适合普通很大的图
        image.compressStyle = UMImage.CompressStyle.QUALITY//质量压缩，适合长图的分享
        ShareAction(context)
                .setPlatform(platform)
                .setCallback(object : UMShareListener {
                    override fun onStart(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "开始分享------")
                    }

                    override fun onResult(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "分享结束------")
                        callBack?.onShareSuccessed(share_media)
                        callBack = null
                    }

                    override fun onError(share_media: SHARE_MEDIA, throwable: Throwable) {
                        LogUtil.e("ydl", "分享出错------" + throwable.message)
                        try {
                            var message = handleMessage(throwable.message!!)
                            ToastUtil.toastShort("分享失败," + message)
                        } catch (e: Exception) {
                            ToastUtil.toastShort("分享错误")
                        }
                        callBack?.onShareFailed(share_media, throwable)
                        callBack = null
                    }

                    override fun onCancel(share_media: SHARE_MEDIA) {
                        LogUtil.e("ydl", "分享取消------")
                    }
                })
                .withMedia(image)
                .share()
    }

    /**
     * 分享小程序类型
     */
    fun shareSmailWeixin(context: Activity, share_title: String, share_url: String, share_context: String?, image: String?, path: String?, id: String?, shareListener: UMShareListener?) {
        val umMin = UMMin(share_url)   //兼容低版本的网页链接
        val img = UMImage(context, image)
        img.compressStyle = UMImage.CompressStyle.SCALE
        umMin.setThumb(img)    // 小程序消息封面图片
        umMin.title = share_title    // 小程序消息title
        umMin.description = share_context    // 小程序消息描述
        umMin.path = path    //小程序页面路径
        umMin.userName = id      // 小程序原始id,在微信平台查询
        ShareAction(context)
                .withMedia(umMin)
                .setPlatform(SHARE_MEDIA.WEIXIN)
                .setCallback(shareListener)
                .share()
    }

    /**
     * 自定义分享弹出框
     * author harvie
     * @param activity
     * @param actions 扩展按钮
     * @param share_title
     * @param share_url
     * @param share_context
     * @param share_head
     */
    fun share(activity: Activity, share_title: String?, share_url: String?, share_context: String?, share_head: String?, actions: List<ShareMoreBean>) {
        var content = share_context
        var image = share_head
        if (share_title == null || share_url == null) {
            ToastHelper.show("缺少分享参数")
            return
        }
        if (TextUtils.isEmpty(share_head)) {
            image = "http://static.ydlcdn.com/v1/images/logo320.png"
        }
        if (TextUtils.isEmpty(content)) content = share_title
        val dialog = CustomShareDialog(activity)
        dialog.setShareBody(share_title, share_url, content ?: "", image!!)
        dialog.addActions(actions)
        dialog.show()

    }

    /**
     * 友盟自带分享弹框
     */
    fun share(activity: Activity, share_title: String?, share_url: String?, share_context: String?, share_head: String?) {
        LogUtil.d("share")
        var content = share_context
        var image = share_head
        if (share_title == null || share_url == null) {
            ToastHelper.show("缺少分享参数")
            return
        }
        if (share_head == null || share_head == "") {
            image = "http://static.ydlcdn.com/v1/images/logo320.png"
        }
        if (TextUtils.isEmpty(content)) content = share_title

        val web = UMWeb(share_url)
        web.title = share_title//标题
        web.setThumb(UMImage(activity, image))  //缩略图
        web.description = content//描述
        val config = ShareBoardConfig()
        config.setIndicatorVisibility(false)
        if (activity.packageName.endsWith("yidianling_atk9")) {
            ShareAction(activity).withMedia(web)
                    .setDisplayList(SHARE_MEDIA.QQ, SHARE_MEDIA.QZONE)
                    .setCallback(object : UMShareListener {
                        override fun onStart(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "开始分享------")
                        }

                        override fun onResult(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "分享结束------")
                        }

                        override fun onError(share_media: SHARE_MEDIA, throwable: Throwable) {
                            LogUtil.e("ydl", "分享出错------" + throwable.message)
                            try {
                                var message = handleMessage(throwable.message!!)
                                ToastUtil.toastShort("分享失败," + message)
                            } catch (e: Exception) {
                                ToastUtil.toastShort("分享错误")
                            }
                        }

                        override fun onCancel(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "分享取消------")
                        }
                    })
                    .open(config)
        } else {
            ShareAction(activity).withMedia(web)
                    .setDisplayList(SHARE_MEDIA.WEIXIN, SHARE_MEDIA.WEIXIN_CIRCLE, SHARE_MEDIA.QQ, SHARE_MEDIA.QZONE)
                    .setCallback(object : UMShareListener {
                        override fun onStart(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "开始分享------")
                        }

                        override fun onResult(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "分享结束------")
                            callBack?.onShareSuccessed(share_media)
                            callBack = null
                        }

                        override fun onError(share_media: SHARE_MEDIA, throwable: Throwable) {
                            LogUtil.e("ydl", "分享出错------" + throwable.message)
                            try {
                                var message = handleMessage(throwable.message!!)
                                ToastUtil.toastShort("分享失败," + message)
                            } catch (e: Exception) {
                                ToastUtil.toastShort("分享错误")
                            }
                            callBack?.onShareFailed(share_media, throwable)
                            callBack = null
                        }

                        override fun onCancel(share_media: SHARE_MEDIA) {
                            LogUtil.e("ydl", "分享取消------")
                        }
                    })
                    .open(config)
        }

    }


    /**
     * 强制处理分享失败消息
     */
    fun handleMessage(msg: String): String {
        var index = msg.indexOf("错误信息")
        var message = msg.substring(index, msg!!.length)
        var lastIndex = message.indexOf(" ")
        message = message.substring(0, lastIndex)
        return message
    }
}

//
/**
 *
 */
class ShareMoreBean(var imageResId: Int, var actionName: String, //扩展按钮动作
                    var shareMoreAction: ShareMoreAction?)

//分享动作
interface ShareMoreAction {
    fun onClick()
}

interface ShareActionCallBack {
    fun onShareSuccessed(share_media: SHARE_MEDIA)
    fun onShareFailed(share_media: SHARE_MEDIA, throwable: Throwable)
}
