package com.ydl.ydlcommon.data

import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.common.tools.RxAppTool
import com.yidianling.common.tools.RxDeviceTool
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.data.http.LogParam
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.YdlCommonApi
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.YdlCommonOut
import io.reactivex.Observable
import io.reactivex.schedulers.Schedulers
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/05
 */
class PlatformHttpImpl private constructor() : IPlatformHttp {

    companion object {
        fun getInstance(): PlatformHttpImpl {
            return Holder.INSTANCE
        }

        fun clearYdlCommonApi() {
            Holder.INSTANCE.api = null
        }
    }

    private var api: YdlCommonApi? = null

    private fun getYdlCommonApi(): YdlCommonApi {
        if (api == null) {
            api = YDLHttpUtils.obtainApi(YdlCommonApi::class.java)
        }
        return api!!
    }


    override fun uploadLog(param: LogParam): Observable<BaseResponse<Any>> {
//        return RxUtils.mapObservable(param)
//                .flatMap { api.uploadLog(it) }
        return Observable.just(param)
                .compose(RxUtils.netCheck())
                .subscribeOn(Schedulers.io())
                .map {
                    val map = HashMap<String, RequestBody>()
                    val mediaType = MediaType.parse("text/plain")
                    map.put("apiurl", RequestBody.create(mediaType, it.apiurl))
                    map.put("os_type", RequestBody.create(mediaType, it.os_type.toString()))
                    map.put("errorCode", RequestBody.create(mediaType, it.errorCode.toString()))
                    map.put("errorMsg", RequestBody.create(mediaType, it.errorMsg))
                    map.put("ffrom", RequestBody.create(mediaType, YdlCommonOut.getChannelName()))
                    map.put("isFromApp", RequestBody.create(mediaType, "1"))
                    map.put("osBuild", RequestBody.create(mediaType, """${RxDeviceTool.getBuildBrandModel()},${RxDeviceTool.getSDKVersionName()},${RxAppTool.getAppVersionName(
                        BaseApp.getApp())}"""))
                    map.put("ts", RequestBody.create(mediaType, (System.currentTimeMillis() / 1000).toString()))
                    map.put("version", RequestBody.create(mediaType, RxAppTool.getAppVersionName(BaseApp.getApp())))
                    val userInfo = ModularServiceManager.getPlatformUserService()?.getUser()
                    if (userInfo != null) {
                        map.put("uid", RequestBody.create(mediaType, userInfo.userId))
                        map.put("accessToken", RequestBody.create(mediaType, userInfo.token))
                    }
                    val fileBody = RequestBody.create(MediaType.parse("multipart/form-data"), it.file)
                    map.put("""uploadlog"; filename="${it.file.name}""", fileBody)
                    map
                }
                .flatMap { getYdlCommonApi().uploadLog(it) }
    }

    private object Holder {
        internal val INSTANCE = PlatformHttpImpl()
    }
}