package com.ydl.ydlcommon.data

import android.content.Context
import android.content.SharedPreferences
import com.ydl.ydlcommon.base.BaseApp

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/27
 */
internal class PlatformLocalImpl private constructor(): IPlatformLocal {

    companion object {
        private val YDL_COMMON = "ydl_common"
        private val VOICE = "voice"
        private val SHAKE = "shake"

        fun getInstance(): PlatformLocalImpl {
            return Holder.INSTANCE
        }
    }

    override fun isVoice(): Boolean {
        return getYdlSP().getBoolean(VOICE, true)
    }

    override fun isShake(): Boolean {
        return getYdlSP().getBoolean(SHAKE, true)
    }

    override fun putVoice(voice: Boolean) {
        getYdlSP().edit().putBoolean(VOICE, voice).apply()
    }

    override fun putShake(shake: Boolean) {
        getYdlSP().edit().putBoolean(SHAKE, shake).apply()
    }

    private fun getYdlSP(): SharedPreferences {
        return BaseApp.getApp().getSharedPreferences(YDL_COMMON, Context.MODE_PRIVATE)
    }

    private object Holder {
        val INSTANCE = PlatformLocalImpl()
    }
}