package com.ydl.ydlcommon.utils

import android.app.ActivityManager
import android.content.Context
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.base.config.YDLConstants.ENV_NEW_TEST
import com.ydl.ydlcommon.base.config.YDLConstants.ENV_TEST
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxAppTool
import com.yidianling.common.tools.RxDeviceTool

/**
 * Created by haorui on 2019/4/25.
 * Des:
 */
object AppUtils {
    fun isServiceRunning(context: Context, className: String): Boolean {
        if (className.isEmpty()) {
            return false
        }
        var isRunning: Boolean = false
        val activityManager: ActivityManager =
            context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
        val serviceList: List<ActivityManager.RunningServiceInfo> =
            activityManager.getRunningServices(30)
        if (serviceList.isEmpty()) {
            return false
        }
        serviceList.forEach { item ->
            if (item.service.className == className) {
                isRunning = true
                return@forEach
            }
        }
        return isRunning
    }

    /**
     * 获取http请求公用参数
     *
     */
    fun getHttpCommonParams(): Map<String, Any> {
        val mMap = mutableMapOf<String, Any>()
        val appEnv = BaseApp.instance.getGlobalConfig().appEnv
        var isDevelopment = "0"

        if (ENV_TEST == appEnv) {
            isDevelopment = "1"
        } else if (ENV_NEW_TEST == appEnv) {
            isDevelopment = "2"
        }
        LogUtil.e("aaaaaapputils"+isDevelopment+"环境"+appEnv)

        val osBuild = "${RxDeviceTool.getBuildBrandModel()},${RxDeviceTool.getSDKVersionName()},${
            RxAppTool.getAppVersionName(
                BaseApp.getApp()
            )
        }"

        val loginBean = ModularServiceManager.getPlatformUserService()?.getUser()

        mMap["isDevelopment"] = isDevelopment
        mMap["uid"] = loginBean?.userId ?: ""
        mMap["accessToken"] = loginBean?.token ?: ""
        mMap["isFromApp"] = "1"
        mMap["version"] = RxAppTool.getAppVersionName(BaseApp.getApp())
        mMap["osBuild"] = osBuild
        mMap["ffrom"] = PlatformDataManager.getRam().getChannelName()
        mMap["osType"] = "android"
        return mMap
    }
}