package com.ydl.ydlcommon.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * bean 转换工具类
 */
public class BeansUtil {

    // Bean --> Map
    public static Map<String, Object> transBean2Map(Object obj) {

        if(obj == null){
            return null;
        }

        Map<String, Object> map = new HashMap();
        Field[] fields = obj.getClass().getFields();
        for (Field field : fields) {
            try {
                boolean accessFlag = field.isAccessible();
                field.setAccessible(true);
                Object o = field.get(obj);
                if (o != null) {
                    map.put(field.getName(),o);
                }
                field.setAccessible(accessFlag);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        return map;

    }
}
