package com.ydl.ydlcommon.utils;

import java.util.LinkedList;

/**
 * Created by haorui on 2019/3/16.
 * Des:固定长度List
 *     如果List里面的元素个数大于了缓存最大容量，则删除链表的顶端元素
 */
public class FixSizeLinkedList<T> extends LinkedList<T> {
    private static final long serialVersionUID = 3292612616231532364L;
    
    // 定义缓存的容量
    private int capacity;

    public FixSizeLinkedList(int capacity) {
        super();
        this.capacity = capacity;
    }

    @Override
    public boolean add(T e) {
        // 超过长度，移除最后一个
        if (size() + 1 > capacity) {
            super.removeFirst();
        }
        return super.add(e);
    }

}
