package com.ydl.ydlcommon.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.ydl.ydlcommon.utils.emoji.EmojiManager;
import com.ydl.ydlcommon.utils.emoji.ImageSpanAlignCenter;
import com.ydl.ydlcommon.R;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MoonUtil {
//	private static final float DEF_SCALE = 0.6f;
	private static final float DEF_SCALE = 0.55f;
	private static final float SMALL_SCALE = 0.45F;
	public static void identifyFaceExpression(Context context,
			View textView, String value,int align ) {
		identifyFaceExpression(context, textView, value, align, DEF_SCALE);
	}

	/**
	 * 动态正文SetText
	 * @param context
	 * @param textView
	 * @param value 正文
	 * @param topic 话题
	 * @param allContent 是否有全文的标示
	 * @param align
	 */
	public static void SetTrendContent(Context context,TextView textView, String value,String topic,String allContent,int align){
//		viewSetText(textView, mSpannableString);
		SpannableString spantopic = new SpannableString(topic);
		spantopic.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_main_theme)), 0, topic.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
		textView.setText(spantopic);
		SpannableString mSpannableString = makeSpannableStringTags(context, value, DEF_SCALE, align);
		textView.append(mSpannableString);
		if(!"".equals(allContent)&&allContent!=null){
			SpannableString spanallContent = new SpannableString(allContent);
			spanallContent.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_main_theme)), 0, allContent.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.append(spanallContent);
		}
//		textView.setMovementMethod(LinkMovementMethod.getInstance());
	}

	/**
	 * 动态列表评论 SetText
	 * @param context
	 * @param textView
	 * @param value 评论内容
	 * @param username 发布评论的人
	 * @param align
	 */
	public static void SetDicuss(Context context,TextView textView,String value,String username,String reply_username,int align){
//		LogUtil.d("username: "+username+ " reply username: "+reply_username);
		if(!"".equals(reply_username)&&reply_username!=null){
			SpannableString spantuser = new SpannableString(username);
			spantuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_default_text_color)), 0, username.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.setText(spantuser);
			textView.append("回复");
			String reply_user_name=reply_username+"：";
			SpannableString spantreplyuser = new SpannableString(reply_user_name);
			spantreplyuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_default_text_color)), 0, reply_user_name.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.append(spantreplyuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}else {
			String usernamed=username+"：";
			SpannableString spantuser = new SpannableString(usernamed);
			spantuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_default_text_color)), 0, usernamed.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.setText(spantuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}

	}


	public static void SetItemDicussContent(Context context,TextView textView,String value,String username,String reply_username,int align){
		if(!"".equals(reply_username)&&reply_username!=null){
			textView.setText("回复");
			String reply_user_name=reply_username+"：";
			SpannableString spantreplyuser = new SpannableString(reply_user_name);
			spantreplyuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_main_theme)), 0, reply_user_name.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.append(spantreplyuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}else {
			String usernamed=username+"：";
			SpannableString spantuser = new SpannableString(usernamed);
			spantuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(R.color.platform_main_theme)), 0, usernamed.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.setText(spantuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}

	}

	/**
	 * 动态列表评论 SetText
	 * @param context
	 * @param textView
	 * @param value 评论内容
	 * @param username 发布评论的人
	 * @param textColor 替换文字颜色
	 * @param align
	 */
	public static void SetDicuss(Context context,TextView textView,String value,String username,int textColor,String reply_username,int align){
		if(!"".equals(reply_username)&&reply_username!=null){
			SpannableString spantuser = new SpannableString(username);
			spantuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(textColor)), 0, username.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.setText(spantuser);
			textView.append("回复");
			String reply_user_name=reply_username+"：";
			SpannableString spantreplyuser = new SpannableString(reply_user_name);
			spantreplyuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(textColor)), 0, reply_user_name.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.append(spantreplyuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}else {
			String usernamed=username+"：";
			SpannableString spantuser = new SpannableString(usernamed);
			spantuser.setSpan(new ForegroundColorSpan(context.getResources().getColor(textColor)), 0, usernamed.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
			textView.setText(spantuser);
			SpannableString mSpannableString = makeSpannableStringTags2(context, value, 0.45f, align);
			textView.append(mSpannableString);
		}

	}

	public static void identifyFaceExpressionAndATags(Context context,
			View textView, String value,int align){
		SpannableString mSpannableString = makeSpannableStringTags(context, value, DEF_SCALE, align);
		viewSetText(textView, mSpannableString);
	}
	
	/** 具体类型的view设置内容
	 * @param textView
	 * @param mSpannableString
	 */
	private static void viewSetText(View textView, SpannableString mSpannableString) {
		if(textView instanceof TextView) {
			TextView tv=(TextView) textView;
			tv.setText(mSpannableString);
		} else if(textView instanceof EditText) {
			EditText et=(EditText) textView;
			et.setText(mSpannableString);
		}
	}
	
	public static void identifyFaceExpression(Context context,
			View textView, String value,int align, float scale) {

		SpannableString mSpannableString = replaceEmoticons(context, value, scale, align);
		viewSetText(textView, mSpannableString);
	}
	/**
	 lstmsgviewholder类使用,只需显示a标签对应的文本
	 */
	public static void identifyFaceExpressionAndTags(Context context,
			View textView, String value,int align, float scale) {
		SpannableString mSpannableString = makeSpannableStringTags(context, value, scale, align,false);
		viewSetText(textView, mSpannableString);
	}

//	private static SpannableString replaceEmoticons(final Context context, String value, float scale, int align) {
//		if(TextUtils.isEmpty(value)) {
//			value="";
//		}
//		SpannableString mSpannableString=null;
//		String[] sts=null;
//		if(value.contains("4444")){
//			sts=value.split("4444");
//		}
//		if(sts!=null){
//			mSpannableString= new SpannableString(sts[0]+sts[1]);
//			int start = mSpannableString.length() - sts[1].length() ;  //超链接起始位置
//			int end = mSpannableString.length();   //超链接结束位置
//			final String url=sts[2];
//			//可以为多部分设置超链接
//			mSpannableString.setSpan(new Clickable(new View.OnClickListener() {
//				@Override
//				public void onClick(View v) {
//					DeliveryListener.getL().showHelp(url);
//				}
//			}), start, end, Spanned.SPAN_MARK_MARK);
//		}
//		if(mSpannableString==null){
//			mSpannableString=new SpannableString(value);
//		}
//
//		Matcher matcher = EmojiManager.getPattern().matcher(value);
//		while (matcher.find()) {
//			int start = matcher.start();
//			int end = matcher.end();
//			String emot = value.substring(start, end);
//			Drawable d = getEmotDrawable(context, emot, scale);
//			if (d != null) {
//				ImageSpan span = new ImageSpan(d, align);
//				mSpannableString.setSpan(span, start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//			}
//		}
//		return mSpannableString;
//	}

     //2017/5/4 云信DEMOv3.6.0
	private static SpannableString replaceEmoticons(Context context, String value, float scale, int align) {
		if(TextUtils.isEmpty(value)) {
			value="";
		}

		SpannableString mSpannableString = new SpannableString(value);
		Matcher matcher = EmojiManager.getPattern().matcher(value);
		while (matcher.find()) {
			int start = matcher.start();
			int end = matcher.end();
			String emot = value.substring(start, end);
			Drawable d = getEmotDrawable(context, emot, scale);
			if (d != null) {
				ImageSpan span = new ImageSpan(d, align);
				mSpannableString.setSpan(span, start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
			}
		}
		return mSpannableString;
	}


	private static Pattern mATagPattern =  Pattern.compile("<a.*?>.*?</a>");
	public static SpannableString makeSpannableStringTags(Context context, String value,float scale,int align) {
		return makeSpannableStringTags(context, value, DEF_SCALE, align, true);
	}
	public static SpannableString makeSpannableStringTags2(Context context, String value,float scale,int align) {
		return makeSpannableStringTags(context, value, scale, align, true);
	}

//	public static SpannableString makeSpannableStringTags(Context context, String value,float scale,int align,boolean bTagClickable) {
//		ArrayList<ATagSpan> tagSpans = new ArrayList<ATagSpan>();
//		if(TextUtils.isEmpty(value)){
//			value="";
//		}
//		//a标签需要替换原始文本,放在moonutil类中
//		Matcher aTagMatcher = mATagPattern.matcher(value);
//
//		int start =0;
//		int end = 0;
//		while (aTagMatcher.find()) {
//			 start = aTagMatcher.start();
//			 end = aTagMatcher.end();
//			String atagString = value.substring(start, end);
//			ATagSpan tagSpan = getTagSpan(atagString);
//			value = value.substring(0,start)+tagSpan.getTag()+value.substring(end);
//			tagSpan.setRange(start, start+tagSpan.getTag().length());
//			tagSpans.add(tagSpan);
//			aTagMatcher= mATagPattern.matcher(value);
//		}
//
//
//		SpannableString mSpannableString = new SpannableString(value);
//		Matcher matcher = EmojiManager.getPattern().matcher(value);
//		while (matcher.find()) {
//			start = matcher.start();
//			end = matcher.end();
//			String emot = value.substring(start, end);
//			Drawable d = getEmotDrawable(context, emot, scale);
//			if (d != null) {
//				ImageSpan span = new ImageSpan(d, align);
//				mSpannableString.setSpan(span, start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//			}
//		}
//
//		if(bTagClickable){
//			for(ATagSpan tagSpan:tagSpans){
//				mSpannableString.setSpan(tagSpan, tagSpan.start, tagSpan.end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
//			}
//		}
//
//		return mSpannableString;
//	}


	//: 2017/5/4 云信DEMOv3.6.0
	public static SpannableString makeSpannableStringTags(Context context, String value,float scale,int align,boolean bTagClickable) {
		ArrayList<ATagSpan> tagSpans = new ArrayList<ATagSpan>();
		if(TextUtils.isEmpty(value)){
			value="";
		}
		//a标签需要替换原始文本,放在moonutil类中
		Matcher aTagMatcher = mATagPattern.matcher(value);

		int start =0;
		int end = 0;
		while (aTagMatcher.find()) {
			start = aTagMatcher.start();
			end = aTagMatcher.end();
			String atagString = value.substring(start, end);
			ATagSpan tagSpan = getTagSpan(atagString);
			value = value.substring(0,start)+tagSpan.getTag()+value.substring(end);
			tagSpan.setRange(start, start+tagSpan.getTag().length());
			tagSpans.add(tagSpan);
			aTagMatcher= mATagPattern.matcher(value);
		}


		SpannableString mSpannableString = new SpannableString(value);
		Matcher matcher = EmojiManager.getPattern().matcher(value);
		while (matcher.find()) {
			start = matcher.start();
			end = matcher.end();
			String emot = value.substring(start, end);
			Drawable d = getEmotDrawable(context, emot, scale);
			if (d != null) {
				ImageSpan span = align == -1 ? new ImageSpanAlignCenter(d) : new ImageSpan(d, align);
				mSpannableString.setSpan(span, start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
			}
		}

		if(bTagClickable){
			for(ATagSpan tagSpan:tagSpans){
				mSpannableString.setSpan(tagSpan, tagSpan.start, tagSpan.end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
			}
		}

		return mSpannableString;
	}
	
	public static void replaceEmoticons(Context context, Editable editable, int start, int count) {
		if (count <= 0 || editable.length() < start + count)
			return;

		CharSequence s = editable.subSequence(start, start + count);
		Matcher matcher = EmojiManager.getPattern().matcher(s);
		while (matcher.find()) {
			int from = start + matcher.start();
			int to = start + matcher.end();
			String emot = editable.subSequence(from, to).toString();
			Drawable d = getEmotDrawable(context, emot, SMALL_SCALE);
			if (d != null) {
				ImageSpan span = new ImageSpan(d, ImageSpan.ALIGN_BOTTOM);
				editable.setSpan(span, from, to, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
			}
		}
	}

	private static Drawable getEmotDrawable(Context context, String text, float scale) {
		Drawable drawable = EmojiManager.getDrawable(context, text);

		// scale
		if (drawable != null) {
			int width = (int) (drawable.getIntrinsicWidth() * scale);
			int height = (int) (drawable.getIntrinsicHeight() * scale);
			drawable.setBounds(0, 0, width, height);
		}
		
		return drawable;
	}
	
	private static ATagSpan getTagSpan(String text){
		String href = null;
		String tag = null;
		if(text.toLowerCase().contains("href")){
			int start = text.indexOf("\"");
			int end = text.indexOf("\"",start+1);
			if(end>start)
				href =text.substring(start+1, end);
		}
		int start = text.indexOf(">");
		int end = text.indexOf("<", start);
		if(end>start)
			tag = text.substring(start+1,end);
		return new ATagSpan(tag,href);
		
	}

	private static class ATagSpan extends ClickableSpan{
		private int start;
		private int end;
		private String mUrl;
		private String tag;
		ATagSpan(String tag, String url) {
			this.tag = tag;
			this.mUrl = url;
		}
		@Override
		public void updateDrawState(TextPaint ds) {
			super.updateDrawState(ds);
			ds.setUnderlineText(true);
		}
		public String getTag(){
			return tag;
		}
		
		public void setRange(int start,int end){
			this.start = start;
			this.end = end;
		}
		
		@Override
		public void onClick(View widget) {
			try {
                if (TextUtils.isEmpty(mUrl))
                    return;
                Uri uri = Uri.parse(mUrl);
                String scheme = uri.getScheme();
                if (TextUtils.isEmpty(scheme)) {
                    mUrl = "http://" + mUrl;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
		}
	}

}
